/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.servlet.util;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.samskivert.util.Logger;
import com.samskivert.util.Tuple;
import com.threerings.servlet.util.ConversionFailedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import javax.servlet.ServletRequest;

public class Parameters {
    protected final ServletRequest _req;

    public Parameters(ServletRequest req) {
        this._req = req;
    }

    public Set<String> names() {
        Set<String> names = this._req.getParameterMap().keySet();
        return names;
    }

    public Collection<String[]> values() {
        Collection<String[]> vals = this._req.getParameterMap().values();
        return vals;
    }

    public Collection<Tuple<String, String>> entries() {
        Set<String> names = this.names();
        ArrayList entries = Lists.newArrayListWithCapacity((int)names.size());
        for (String name : names) {
            for (String val : this.getAll(name, new String[0])) {
                entries.add(Tuple.newTuple((Object)name, (Object)val));
            }
        }
        return entries;
    }

    public boolean has(String name) {
        return this._req.getParameterValues(name) != null;
    }

    public String get(String name) {
        return this.get(name, null);
    }

    public String get(String name, String def) {
        String[] vals = this._req.getParameterValues(name);
        if (vals != null) {
            Preconditions.checkState((vals.length == 1 ? 1 : 0) != 0, (Object)Logger.format((Object)"Requested a single value parameter, but there were multiple values", (Object[])new Object[]{"name", name, "values", vals}));
            return vals[0];
        }
        return def;
    }

    public <T> T get(String name, Function<String, T> converter, T def) {
        String val = this.get(name);
        if (val != null) {
            return Parameters.convert(converter, name, val);
        }
        return def;
    }

    public String require(String name) {
        String val = this.get(name);
        Preconditions.checkNotNull((Object)val, (Object)("'" + name + "' was required but not present"));
        return val;
    }

    public <T> T require(String name, Function<String, T> converter) {
        return Parameters.convert(converter, name, this.require(name));
    }

    public String[] getAll(String name, String ... defaultValues) {
        String[] vals = this._req.getParameterValues(name);
        if (vals == null) {
            return defaultValues;
        }
        return vals;
    }

    public <T> Collection<T> getAll(final String name, final Function<String, T> converter, T ... defaultValues) {
        String[] vals = this._req.getParameterValues(name);
        if (vals == null) {
            return Arrays.asList(defaultValues);
        }
        return Lists.transform(Arrays.asList(vals), (Function)new Function<String, T>(){

            public T apply(String from) {
                return Parameters.convert(converter, name, from);
            }
        });
    }

    protected static <T> T convert(Function<String, T> converter, String name, String val) {
        try {
            return (T)converter.apply((Object)val);
        }
        catch (RuntimeException re) {
            ConversionFailedException fail = re instanceof ConversionFailedException ? (ConversionFailedException)re : new ConversionFailedException(re, (Object)"Failed converting parameter", new Object[0]);
            fail.append("name", name, "value", val);
            throw fail;
        }
    }
}

