/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary.internal;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import com.squareup.leakcanary.internal.LeakCanaryUi;

public final class MoreDetailsView
extends View {
    private static final Paint iconPaint = new Paint(1);
    private boolean opened;

    public MoreDetailsView(Context context, AttributeSet attrs) {
        super(context, attrs);
        float strokeSize = LeakCanaryUi.dpToPixel(2.0f, this.getResources());
        iconPaint.setStrokeWidth(strokeSize);
    }

    protected void onDraw(Canvas canvas) {
        int width = this.getWidth();
        int height = this.getHeight();
        int halfHeight = height / 2;
        int halfWidth = width / 2;
        if (this.opened) {
            canvas.drawLine(0.0f, (float)halfHeight, (float)width, (float)halfHeight, iconPaint);
        } else {
            canvas.drawLine(0.0f, (float)halfHeight, (float)width, (float)halfHeight, iconPaint);
            canvas.drawLine((float)halfWidth, 0.0f, (float)halfWidth, (float)height, iconPaint);
        }
    }

    public void setOpened(boolean opened) {
        if (opened != this.opened) {
            this.opened = opened;
            this.invalidate();
        }
    }

    static {
        iconPaint.setColor(-8083771);
    }
}

