/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary.internal;

import android.content.Context;
import android.text.Html;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import com.squareup.leakcanary.Exclusion;
import com.squareup.leakcanary.LeakTrace;
import com.squareup.leakcanary.LeakTraceElement;
import com.squareup.leakcanary.R;
import com.squareup.leakcanary.internal.DisplayLeakConnectorView;
import com.squareup.leakcanary.internal.MoreDetailsView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class DisplayLeakAdapter
extends BaseAdapter {
    private static final int TOP_ROW = 0;
    private static final int NORMAL_ROW = 1;
    private boolean[] opened = new boolean[0];
    private List<LeakTraceElement> elements = Collections.emptyList();
    private String referenceKey;
    private String referenceName = "";

    DisplayLeakAdapter() {
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        Context context = parent.getContext();
        if (this.getItemViewType(position) == 0) {
            if (convertView == null) {
                convertView = LayoutInflater.from((Context)context).inflate(R.layout.leak_canary_ref_top_row, parent, false);
            }
            TextView textView = (TextView)DisplayLeakAdapter.findById(convertView, R.id.leak_canary_row_text);
            textView.setText((CharSequence)context.getPackageName());
        } else {
            if (convertView == null) {
                convertView = LayoutInflater.from((Context)context).inflate(R.layout.leak_canary_ref_row, parent, false);
            }
            TextView textView = (TextView)DisplayLeakAdapter.findById(convertView, R.id.leak_canary_row_text);
            boolean isRoot = position == 1;
            boolean isLeakingInstance = position == this.getCount() - 1;
            LeakTraceElement element = this.getItem(position);
            String htmlString = this.elementToHtmlString(element, isRoot, this.opened[position]);
            if (isLeakingInstance && !this.referenceName.equals("") && this.opened[position]) {
                htmlString = htmlString + " <font color='#919191'>" + this.referenceName + "</font>";
            }
            textView.setText((CharSequence)Html.fromHtml((String)htmlString));
            DisplayLeakConnectorView connector = (DisplayLeakConnectorView)((Object)DisplayLeakAdapter.findById(convertView, R.id.leak_canary_row_connector));
            if (isRoot) {
                connector.setType(DisplayLeakConnectorView.Type.START);
            } else if (isLeakingInstance) {
                connector.setType(DisplayLeakConnectorView.Type.END);
            } else {
                connector.setType(DisplayLeakConnectorView.Type.NODE);
            }
            MoreDetailsView moreDetailsView = (MoreDetailsView)((Object)DisplayLeakAdapter.findById(convertView, R.id.leak_canary_row_more));
            moreDetailsView.setOpened(this.opened[position]);
        }
        return convertView;
    }

    private String elementToHtmlString(LeakTraceElement element, boolean root, boolean opened) {
        Exclusion exclusion;
        String simpleName;
        String qualifier;
        int separator;
        String htmlString = "";
        if (element.referenceName == null) {
            htmlString = htmlString + "leaks ";
        } else if (!root) {
            htmlString = htmlString + "references ";
        }
        if (element.type == LeakTraceElement.Type.STATIC_FIELD) {
            htmlString = htmlString + "<font color='#c48a47'>static</font> ";
        }
        if (element.holder == LeakTraceElement.Holder.ARRAY || element.holder == LeakTraceElement.Holder.THREAD) {
            htmlString = htmlString + "<font color='#f3cf83'>" + element.holder.name().toLowerCase() + "</font> ";
        }
        if ((separator = element.className.lastIndexOf(46)) == -1) {
            qualifier = "";
            simpleName = element.className;
        } else {
            qualifier = element.className.substring(0, separator + 1);
            simpleName = element.className.substring(separator + 1);
        }
        if (opened) {
            htmlString = htmlString + "<font color='#919191'>" + qualifier + "</font>";
        }
        String styledClassName = "<font color='#ffffff'>" + simpleName + "</font>";
        htmlString = htmlString + styledClassName;
        htmlString = element.referenceName != null ? htmlString + ".<font color='#998bb5'>" + element.referenceName.replaceAll("<", "&lt;").replaceAll(">", "&gt;") + "</font>" : htmlString + " <font color='#f3cf83'>instance</font>";
        if (opened && element.extra != null) {
            htmlString = htmlString + " <font color='#919191'>" + element.extra + "</font>";
        }
        if ((exclusion = element.exclusion) != null) {
            if (opened) {
                htmlString = htmlString + "<br/><br/>Excluded by rule";
                if (exclusion.name != null) {
                    htmlString = htmlString + " <font color='#ffffff'>" + exclusion.name + "</font>";
                }
                htmlString = htmlString + " matching <font color='#f3cf83'>" + exclusion.matching + "</font>";
                if (exclusion.reason != null) {
                    htmlString = htmlString + " because <font color='#f3cf83'>" + exclusion.reason + "</font>";
                }
            } else {
                htmlString = htmlString + " (excluded)";
            }
        }
        return htmlString;
    }

    public void update(LeakTrace leakTrace, String referenceKey, String referenceName) {
        if (referenceKey.equals(this.referenceKey)) {
            return;
        }
        this.referenceKey = referenceKey;
        this.referenceName = referenceName;
        this.elements = new ArrayList<LeakTraceElement>(leakTrace.elements);
        this.opened = new boolean[1 + this.elements.size()];
        this.notifyDataSetChanged();
    }

    public void toggleRow(int position) {
        this.opened[position] = !this.opened[position];
        this.notifyDataSetChanged();
    }

    public int getCount() {
        return 1 + this.elements.size();
    }

    public LeakTraceElement getItem(int position) {
        if (this.getItemViewType(position) == 0) {
            return null;
        }
        return this.elements.get(position - 1);
    }

    public int getViewTypeCount() {
        return 2;
    }

    public int getItemViewType(int position) {
        if (position == 0) {
            return 0;
        }
        return 1;
    }

    public long getItemId(int position) {
        return position;
    }

    private static <T extends View> T findById(View view, int id2) {
        return (T)view.findViewById(id2);
    }
}

