/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import com.squareup.leakcanary.Preconditions;
import com.squareup.leakcanary.RefWatcher;

public final class ActivityRefWatcher {
    private final Application.ActivityLifecycleCallbacks lifecycleCallbacks = new Application.ActivityLifecycleCallbacks(){

        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        }

        public void onActivityStarted(Activity activity) {
        }

        public void onActivityResumed(Activity activity) {
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }

        public void onActivityDestroyed(Activity activity) {
            ActivityRefWatcher.this.onActivityDestroyed(activity);
        }
    };
    private final Application application;
    private final RefWatcher refWatcher;

    @Deprecated
    public static void installOnIcsPlus(Application application, RefWatcher refWatcher) {
        ActivityRefWatcher.install(application, refWatcher);
    }

    public static void install(Application application, RefWatcher refWatcher) {
        new ActivityRefWatcher(application, refWatcher).watchActivities();
    }

    public ActivityRefWatcher(Application application, RefWatcher refWatcher) {
        this.application = (Application)Preconditions.checkNotNull((Object)application, (String)"application");
        this.refWatcher = (RefWatcher)Preconditions.checkNotNull((Object)refWatcher, (String)"refWatcher");
    }

    void onActivityDestroyed(Activity activity) {
        this.refWatcher.watch((Object)activity);
    }

    public void watchActivities() {
        this.stopWatchingActivities();
        this.application.registerActivityLifecycleCallbacks(this.lifecycleCallbacks);
    }

    public void stopWatchingActivities() {
        this.application.unregisterActivityLifecycleCallbacks(this.lifecycleCallbacks);
    }
}

