/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.whitespace.PadOption;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.util.Locale;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.lang3.ArrayUtils;

public class MethodParamPadCheck
extends Check {
    public static final String MSG_LINE_PREVIOUS = "line.previous";
    public static final String MSG_WS_PRECEDED = "ws.preceded";
    public static final String MSG_WS_NOT_PRECEDED = "ws.notPreceded";
    private boolean allowLineBreaks;
    private PadOption option = PadOption.NOSPACE;

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{8, 136, 27, 9, 42, 155};
    }

    @Override
    public int[] getRequiredTokens() {
        return ArrayUtils.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST parenAST;
        if (ast.getType() == 27) {
            parenAST = ast;
        } else {
            parenAST = ast.findFirstToken(76);
            if (parenAST == null) {
                return;
            }
        }
        String line = this.getLines()[parenAST.getLineNo() - 1];
        if (CommonUtils.hasWhitespaceBefore(parenAST.getColumnNo(), line)) {
            if (!this.allowLineBreaks) {
                this.log(parenAST, MSG_LINE_PREVIOUS, parenAST.getText());
            }
        } else {
            int before = parenAST.getColumnNo() - 1;
            if (this.option == PadOption.NOSPACE && Character.isWhitespace(line.charAt(before))) {
                this.log(parenAST, MSG_WS_PRECEDED, parenAST.getText());
            } else if (this.option == PadOption.SPACE && !Character.isWhitespace(line.charAt(before))) {
                this.log(parenAST, MSG_WS_NOT_PRECEDED, parenAST.getText());
            }
        }
    }

    public void setAllowLineBreaks(boolean allowLineBreaks) {
        this.allowLineBreaks = allowLineBreaks;
    }

    public void setOption(String optionStr) {
        try {
            this.option = PadOption.valueOf(optionStr.trim().toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException iae) {
            throw new ConversionException("unable to parse " + optionStr, (Throwable)iae);
        }
    }
}

