/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server;

import com.perforce.p4java.impl.mapbased.server.ServerAddress;
import com.perforce.p4java.server.IServerAddress;
import java.net.URISyntaxException;
import java.util.Properties;

public class ServerAddressBuilder {
    private IServerAddress.Protocol protocol = null;
    private String host = null;
    private int port = -1;
    private String query = null;
    private Properties properties = null;
    private String uri = null;

    public ServerAddressBuilder(String serverAddress) throws URISyntaxException {
        if (serverAddress == null) {
            throw new IllegalArgumentException("The server address cannot be null.");
        }
        this.parseUri(serverAddress);
    }

    private void parseUri(String uri) throws URISyntaxException {
        this.uri = uri;
        int protoPartEnd = uri.indexOf("://");
        if (protoPartEnd < 0) {
            throw new URISyntaxException(uri, "missing or malformed Perforce scheme / protocol part");
        }
        String protoPart = uri.substring(0, protoPartEnd);
        if (protoPart.length() + 3 >= uri.length()) {
            throw new URISyntaxException(uri, "missing or malformed Perforce server hostname");
        }
        this.protocol = IServerAddress.Protocol.fromString(protoPart);
        if (this.protocol == null) {
            throw new URISyntaxException(uri, "unknown protocol");
        }
        String restStr = uri.substring(protoPartEnd + 3);
        int portStart = restStr.indexOf(":");
        int queryStart = restStr.indexOf("?");
        if (portStart == 0) {
            throw new URISyntaxException(uri, "missing or malformed Perforce server hostname");
        }
        if (portStart < 0 || queryStart > 0 && queryStart < portStart) {
            throw new URISyntaxException(uri, "missing or malformed Perforce server port specifier");
        }
        this.host = restStr.substring(0, portStart);
        String portPart = null;
        if (queryStart > 0) {
            portPart = restStr.substring(portStart + 1, queryStart);
            if (queryStart >= restStr.length()) {
                throw new URISyntaxException(uri, "empty or malformed P4Java query string");
            }
            this.query = restStr.substring(queryStart + 1);
        } else {
            portPart = restStr.substring(portStart + 1);
        }
        try {
            this.port = new Integer(portPart);
        }
        catch (NumberFormatException nfe) {
            throw new URISyntaxException(uri, "non-numeric Perforce server port specifier");
        }
        if (this.query != null) {
            String[] params;
            if (this.properties == null) {
                this.properties = new Properties();
            }
            for (String param : params = this.query.split("&")) {
                String[] pair;
                if (param == null || (pair = param.split("=")).length <= 0 || pair[0] == null) continue;
                if (pair.length > 1) {
                    this.properties.put(pair[0], pair[1]);
                    continue;
                }
                this.properties.put(pair[0], (Object)null);
            }
        }
    }

    public ServerAddress build() {
        return new ServerAddress(this);
    }

    public IServerAddress.Protocol getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getQuery() {
        return this.query;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getUri() {
        return this.uri;
    }
}

