/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.sys;

import com.perforce.p4java.Log;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.impl.generic.sys.ISystemFileCommandsHelper;
import com.perforce.p4java.impl.mapbased.rpc.func.client.ClientMessage;
import com.perforce.p4java.impl.mapbased.rpc.func.helper.StringHelper;
import com.perforce.p4java.impl.mapbased.rpc.msg.RpcMessage;
import com.perforce.p4java.impl.mapbased.rpc.sys.helper.SymbolicLinkHelper;
import com.perforce.p4java.impl.mapbased.rpc.sys.helper.SysFileHelperBridge;
import com.perforce.p4java.impl.mapbased.rpc.sys.helper.UnicodeHelper;
import com.perforce.p4java.impl.mapbased.server.Server;
import com.perforce.p4java.server.SystemInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum RpcPerforceFileType {
    FST_TEXT,
    FST_BINARY,
    FST_GZIP,
    FST_DIRECTORY,
    FST_SYMLINK,
    FST_RESOURCE,
    FST_SPECIAL,
    FST_MISSING,
    FST_CANTTELL,
    FST_EMPTY,
    FST_UNICODE,
    FST_GUNZIP,
    FST_UTF16,
    FST_ATEXT,
    FST_XTEXT,
    FST_RTEXT,
    FST_RXTEXT,
    FST_CBINARY,
    FST_XBINARY,
    FST_XSYMLINK,
    FST_XRESOURCE,
    FST_APPLETEXT,
    FST_APPLEFILE,
    FST_XAPPLEFILE,
    FST_XAPPLETEXT,
    FST_XUNICODE,
    FST_XRTEXT,
    FST_XUTF16,
    FST_XGUNZIP,
    FST_RCS;

    public static final String TRACE_PREFIX = "RpcPerforceFileType";
    private static final ISystemFileCommandsHelper fileCommands;
    private static CtAction symlinkAction;
    private static ActionTableElement[] actionTable;
    private static final byte[] pdfMagic;
    private static final byte[][] cBinaryMagicTable;

    public static RpcPerforceFileType decodeFromServerString(String str) {
        if (str == null) {
            return FST_TEXT;
        }
        int tf = 0;
        int tl = 0;
        int tu = 0;
        switch (str.length()) {
            default: {
                tu = StringHelper.hexcharToInt(str.charAt(2));
            }
            case 2: {
                tl = StringHelper.hexcharToInt(str.charAt(1));
            }
            case 1: {
                tf = StringHelper.hexcharToInt(str.charAt(0));
            }
            case 0: 
        }
        switch (tu << 8 | tf) {
            case 0: {
                return FST_TEXT;
            }
            case 1: {
                return FST_BINARY;
            }
            case 2: {
                return FST_XTEXT;
            }
            case 3: {
                return FST_XBINARY;
            }
            case 4: {
                return FST_SYMLINK;
            }
            case 5: {
                return FST_RESOURCE;
            }
            case 6: {
                return FST_XSYMLINK;
            }
            case 7: {
                return FST_XRESOURCE;
            }
            case 8: {
                return FST_UNICODE;
            }
            case 9: {
                return FST_RTEXT;
            }
            case 10: {
                return FST_XUNICODE;
            }
            case 11: {
                return FST_XRTEXT;
            }
            case 12: {
                return FST_APPLETEXT;
            }
            case 13: {
                return FST_APPLEFILE;
            }
            case 14: {
                return FST_XAPPLETEXT;
            }
            case 15: {
                return FST_XAPPLEFILE;
            }
            case 24: {
                return FST_UTF16;
            }
            case 26: {
                return FST_XUTF16;
            }
            case 257: {
                return FST_GUNZIP;
            }
            case 259: {
                return FST_XGUNZIP;
            }
        }
        return FST_BINARY;
    }

    public boolean isExecutable() {
        switch (this) {
            case FST_XTEXT: 
            case FST_XAPPLEFILE: 
            case FST_XBINARY: 
            case FST_XUNICODE: 
            case FST_XUTF16: 
            case FST_XGUNZIP: {
                return true;
            }
        }
        return false;
    }

    public static RpcPerforceFileType inferFileType(File file, boolean isUnicodeServer, Charset clientCharset) {
        if (file == null) {
            throw new NullPointerError("Null file handle passed to RpcPerforceFileType.inferFileType()");
        }
        try {
            if (!file.exists()) {
                return FST_MISSING;
            }
            if (file.isDirectory()) {
                return FST_DIRECTORY;
            }
            if (RpcPerforceFileType.isProbablySymLink(file)) {
                return FST_SYMLINK;
            }
            if (!file.isFile()) {
                return FST_CANTTELL;
            }
            if (file.length() == 0L) {
                return FST_EMPTY;
            }
            return RpcPerforceFileType.inferFileTypeFromContents(file, fileCommands.canExecute(file.getPath()), isUnicodeServer, clientCharset);
        }
        catch (Exception exc) {
            Log.exception(exc);
            return FST_CANTTELL;
        }
    }

    public static RpcServerTypeStringSpec getServerFileTypeString(String clientPath, RpcPerforceFileType fileType, String forceType, int xfiles) {
        if (fileType != null) {
            for (ActionTableElement atElement : actionTable) {
                if (atElement.checkType != fileType) continue;
                return RpcPerforceFileType.getAction(clientPath, xfiles, atElement, forceType);
            }
        }
        Log.error("Encountered null or unknown filetype in getServerFileTypeString()");
        return new RpcServerTypeStringSpec(null, new RpcMessage(ClientMessage.ClientMessageId.CANT_ADD_FILE_TYPE, 1, 34, new String[]{clientPath, "unknown"}));
    }

    private static boolean isProbablySymLink(File file) {
        if (file.exists()) {
            ISystemFileCommandsHelper helper = SysFileHelperBridge.getSysFileCommands();
            if (helper != null && helper.isSymlink(file.getPath())) {
                return true;
            }
            if (!Server.isRunningOnWindows()) {
                try {
                    if (SystemInfo.isMac() ? !file.getAbsolutePath().equalsIgnoreCase(file.getCanonicalPath()) : !file.getAbsolutePath().equals(file.getCanonicalPath())) {
                        return true;
                    }
                }
                catch (IOException ioexc) {
                    Log.warn("unexpected exception in RpcPerforceFileType.isProbablySymLink(): " + ioexc.getLocalizedMessage());
                    Log.exception(ioexc);
                }
            }
        }
        return false;
    }

    private static RpcServerTypeStringSpec getAction(String clientPath, int xlevel, ActionTableElement atElement, String forceType) {
        switch (atElement.ctActions[atElement.xlevel >= xlevel ? 0 : 1]) {
            case OK: {
                if (forceType != null) {
                    return new RpcServerTypeStringSpec(forceType, null);
                }
                return new RpcServerTypeStringSpec(atElement.type, null);
            }
            case ASS: {
                if (forceType != null) {
                    return new RpcServerTypeStringSpec(forceType, new RpcMessage(ClientMessage.ClientMessageId.ASSUMING_FILE_TYPE, 1, 34, new String[]{clientPath, atElement.type, forceType}));
                }
                return new RpcServerTypeStringSpec(atElement.altType, new RpcMessage(ClientMessage.ClientMessageId.ASSUMING_FILE_TYPE, 1, 34, new String[]{clientPath, atElement.type, atElement.altType}));
            }
            case SUBST: {
                return new RpcServerTypeStringSpec(atElement.altType, new RpcMessage(ClientMessage.ClientMessageId.SUBSTITUTING_FILE_TYPE, 1, 34, new String[]{clientPath, atElement.altType, atElement.type}));
            }
            case CANT: {
                return new RpcServerTypeStringSpec(null, new RpcMessage(ClientMessage.ClientMessageId.CANT_ADD_FILE_TYPE, 1, 34, new String[]{clientPath, atElement.type}));
            }
        }
        return new RpcServerTypeStringSpec(null, new RpcMessage(ClientMessage.ClientMessageId.CANT_ADD_FILE_TYPE, 1, 34, new String[]{clientPath, atElement.type}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RpcPerforceFileType inferFileTypeFromContents(File file, boolean isExecutable, boolean isUnicodeServer, Charset clientCharset) {
        byte[] bytes = new byte[1024];
        FileInputStream inStream = null;
        int bytesRead = 0;
        try {
            inStream = new FileInputStream(file);
            bytesRead = inStream.read(bytes);
            if (bytesRead < 0) {
                RpcPerforceFileType rpcPerforceFileType = FST_CANTTELL;
                return rpcPerforceFileType;
            }
            if (bytesRead == 0) {
                RpcPerforceFileType rpcPerforceFileType = FST_EMPTY;
                return rpcPerforceFileType;
            }
            if (RpcPerforceFileType.isPDF(bytes, bytesRead)) {
                RpcPerforceFileType rpcPerforceFileType = isExecutable ? FST_XBINARY : FST_BINARY;
                return rpcPerforceFileType;
            }
            if (RpcPerforceFileType.isAsciiText(bytes, bytesRead)) {
                RpcPerforceFileType rpcPerforceFileType = isExecutable ? FST_XTEXT : FST_TEXT;
                return rpcPerforceFileType;
            }
            if (RpcPerforceFileType.isKnownCBinary(bytes, bytesRead)) {
                RpcPerforceFileType rpcPerforceFileType = FST_CBINARY;
                return rpcPerforceFileType;
            }
            if (isUnicodeServer && RpcPerforceFileType.isProbablyUnicode(bytes, bytesRead, clientCharset)) {
                RpcPerforceFileType rpcPerforceFileType = isExecutable ? FST_XUNICODE : FST_UNICODE;
                return rpcPerforceFileType;
            }
            if (RpcPerforceFileType.isProbablyBinary(bytes, bytesRead)) {
                RpcPerforceFileType rpcPerforceFileType = isExecutable ? FST_XBINARY : FST_BINARY;
                return rpcPerforceFileType;
            }
        }
        catch (IOException ioexc) {
            Log.warn("Unexpected exception: " + ioexc.getMessage());
            Log.exception(ioexc);
            RpcPerforceFileType rpcPerforceFileType = FST_CANTTELL;
            return rpcPerforceFileType;
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException exc) {
                    Log.warn("unable to close input stream; exception follows...");
                    Log.exception(exc);
                }
            }
        }
        return FST_TEXT;
    }

    private static boolean isProbablyUnicode(byte[] bytes, int bytesRead, Charset clientCharset) {
        if (bytes != null && bytesRead >= 2) {
            if (bytes.length >= 3 && bytes[0] == -17 && bytes[1] == -69 && bytes[2] == -65) {
                return true;
            }
            if (bytes.length >= 2 && bytes[0] == -1 && bytes[1] == -2) {
                return true;
            }
            if (bytes.length >= 4 && bytes[0] == -2 && bytes[1] == -1 && bytes[2] == 0 && bytes[3] == 0) {
                return true;
            }
            if (bytes.length >= 4 && bytes[0] == 0 && bytes[1] == 0 && bytes[2] == -2 && bytes[3] == -1) {
                return true;
            }
            return UnicodeHelper.inferCharset(bytes, bytesRead, clientCharset);
        }
        return false;
    }

    private static boolean isPDF(byte[] bytes, int bytesRead) {
        if (bytesRead > pdfMagic.length) {
            int i = 0;
            for (byte b : pdfMagic) {
                if (b == bytes[i++]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isAsciiText(byte[] bytes, int bytesRead) {
        if (bytes == null) {
            return false;
        }
        for (int i = 0; i < bytesRead; ++i) {
            if (bytes[i] >= 7) continue;
            return false;
        }
        return true;
    }

    private static boolean isKnownCBinary(byte[] bytes, int bytesRead) {
        if (bytesRead > 0) {
            for (byte[] magicBytes : cBinaryMagicTable) {
                if (bytesRead <= magicBytes.length) continue;
                int i = 0;
                for (byte b : magicBytes) {
                    if (bytes[i++] != b) break;
                }
                if (i != magicBytes.length) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isProbablyBinary(byte[] bytes, int bytesRead) {
        int x = -128;
        int y = -97;
        if (bytesRead > 0) {
            for (int i = 0; i < bytesRead; ++i) {
                byte byteVal = bytes[i];
                if ((byteVal >= 7 || byteVal < 0) && (byteVal < -128 || byteVal > -97)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        fileCommands = SysFileHelperBridge.getSysFileCommands();
        symlinkAction = SymbolicLinkHelper.isSymbolicLinkCapable() ? CtAction.OK : CtAction.CANT;
        actionTable = new ActionTableElement[]{new ActionTableElement(FST_TEXT, 0, CtAction.OK, CtAction.OK, "text", "text"), new ActionTableElement(FST_XTEXT, 0, CtAction.SUBST, CtAction.OK, "xtext", "text"), new ActionTableElement(FST_BINARY, 0, CtAction.OK, CtAction.OK, "binary", "binary"), new ActionTableElement(FST_XBINARY, 0, CtAction.SUBST, CtAction.OK, "xbinary", "binary"), new ActionTableElement(FST_APPLEFILE, 4, CtAction.SUBST, CtAction.OK, "apple", "binary"), new ActionTableElement(FST_XAPPLEFILE, 4, CtAction.SUBST, CtAction.OK, "apple+x", "binary"), new ActionTableElement(FST_CBINARY, 3, CtAction.SUBST, CtAction.OK, "ubinary", "binary"), new ActionTableElement(FST_SYMLINK, 1, CtAction.CANT, symlinkAction, "symlink", null), new ActionTableElement(FST_RESOURCE, 2, CtAction.CANT, CtAction.OK, "resource", null), new ActionTableElement(FST_SPECIAL, -1, CtAction.CANT, CtAction.CANT, "special", null), new ActionTableElement(FST_DIRECTORY, -1, CtAction.CANT, CtAction.CANT, "directory", null), new ActionTableElement(FST_MISSING, -1, CtAction.ASS, CtAction.ASS, "missing", "text"), new ActionTableElement(FST_CANTTELL, -1, CtAction.ASS, CtAction.ASS, "unreadable", "text"), new ActionTableElement(FST_EMPTY, -1, CtAction.ASS, CtAction.ASS, "empty", "text"), new ActionTableElement(FST_UNICODE, 5, CtAction.SUBST, CtAction.OK, "unicode", "text"), new ActionTableElement(FST_XUNICODE, 5, CtAction.SUBST, CtAction.OK, "xunicode", "text"), new ActionTableElement(FST_UTF16, 6, CtAction.SUBST, CtAction.OK, "utf16", "binary"), new ActionTableElement(FST_XUTF16, 6, CtAction.SUBST, CtAction.OK, "xutf16", "binary"), new ActionTableElement(FST_TEXT, 0, CtAction.OK, CtAction.OK, "text", "text")};
        pdfMagic = new byte[]{37, 80, 68, 70, 45};
        cBinaryMagicTable = new byte[][]{{71, 73, 70}, {-1, -40, -1, -18}, {-1, -40, -1, -31}, {31, -117}, {-1, 31}, {31, -99}, {80, 75, 3, 4}, {80, 75, 5, 6}, {-119, 80, 78, 71}, {-54, -2, -70, -66}};
    }

    private static class ActionTableElement {
        public RpcPerforceFileType checkType = null;
        public int xlevel = 0;
        public CtAction[] ctActions = new CtAction[2];
        public String type = null;
        public String altType = null;

        public ActionTableElement(RpcPerforceFileType checkType, int xlevel, CtAction ctActions0, CtAction ctActions1, String type, String altType) {
            this.checkType = checkType;
            this.xlevel = xlevel;
            this.ctActions[0] = ctActions0;
            this.ctActions[1] = ctActions1;
            this.type = type;
            this.altType = altType;
        }
    }

    public static class RpcServerTypeStringSpec {
        private String serverTypeString = null;
        private RpcMessage error = null;

        public RpcServerTypeStringSpec(String str, RpcMessage error) {
            this.serverTypeString = str;
            this.error = error;
        }

        public String getServerTypeString() {
            return this.serverTypeString;
        }

        public RpcMessage getMsg() {
            return this.error;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CtAction {
        OK,
        ASS,
        SUBST,
        CANT;

    }
}

