/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.packet;

import com.perforce.p4java.Log;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.ConnectionNotConnectedException;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.exception.ProtocolError;
import com.perforce.p4java.exception.UnimplementedError;
import com.perforce.p4java.impl.mapbased.rpc.CommandEnv;
import com.perforce.p4java.impl.mapbased.rpc.RpcServer;
import com.perforce.p4java.impl.mapbased.rpc.connection.RpcConnection;
import com.perforce.p4java.impl.mapbased.rpc.func.RpcFunctionSpec;
import com.perforce.p4java.impl.mapbased.rpc.func.client.ClientFunctionDispatcher;
import com.perforce.p4java.impl.mapbased.rpc.func.proto.FlowControl;
import com.perforce.p4java.impl.mapbased.rpc.func.proto.ProtocolFunctionDispatcher;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacket;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RpcPacketDispatcher {
    public static final String TRACE_PREFIX = "RpcPacketDispatcher";
    private FlowControl flowController = null;
    private ProtocolFunctionDispatcher protocolDispatcher = null;
    private ClientFunctionDispatcher clientDispatcher = null;
    private Properties props = null;

    public RpcPacketDispatcher(Properties props, RpcServer server) {
        this.props = props;
        this.protocolDispatcher = new ProtocolFunctionDispatcher(this, this.props);
        this.clientDispatcher = new ClientFunctionDispatcher(this, this.props, server);
        this.flowController = new FlowControl(this, this.props);
    }

    public Map<String, Object>[] dispatch(CommandEnv cmdEnv) throws ConnectionException, AccessException {
        if (cmdEnv == null) {
            throw new NullPointerError("Null command environment passed to main dispatcher");
        }
        if (cmdEnv.getRpcConnection() == null) {
            throw new NullPointerError("Null rpc connection passed to main dispatcher");
        }
        int cmdCallBackKey = cmdEnv.getCmdCallBackKey();
        RpcConnection rpcConnection = cmdEnv.getRpcConnection();
        Vector<Map<String, Object>> resultsMapVec = new Vector<Map<String, Object>>();
        cmdEnv.setResultsMapVec(resultsMapVec);
        try {
            RpcPacketDispatcherMode dispatchMode = RpcPacketDispatcherMode.PRIMAL;
            RpcPacket packet = null;
            if (cmdEnv.getProgressCallback() != null) {
                cmdEnv.getProgressCallback().start(cmdCallBackKey);
            }
            block19: while ((packet = rpcConnection.getRpcPacket(cmdEnv.getFieldRule())) != null) {
                Map<String, Object> paramMap = null;
                String funcNameStr = null;
                RpcFunctionSpec func = RpcFunctionSpec.NONE;
                paramMap = packet.getResultsMap();
                if (paramMap == null) {
                    throw new ProtocolError("Null results map in P4JRpcTextPacket");
                }
                funcNameStr = packet.getFuncNameString();
                if (funcNameStr == null) {
                    throw new ProtocolError("Null function value string in dispatch text packet");
                }
                func = RpcFunctionSpec.decode(funcNameStr);
                if (func == RpcFunctionSpec.NONE) {
                    throw new ProtocolError("Unable to decode function in RpcPacket; func string: " + funcNameStr);
                }
                switch (func.getType()) {
                    case CLIENT: {
                        switch (this.clientDispatcher.dispatch(dispatchMode, func, cmdEnv, paramMap)) {
                            case CONTINUE: {
                                continue block19;
                            }
                            case CONTINUE_LOOP: {
                                dispatchMode = RpcPacketDispatcherMode.LOOP;
                                continue block19;
                            }
                            case STOP_NORMAL: {
                                return resultsMapVec.toArray(new HashMap[resultsMapVec.size()]);
                            }
                        }
                        continue block19;
                    }
                    case USER: {
                        throw new ProtocolError("Unexpected user function in dispatch: '" + funcNameStr + "'");
                    }
                    case SERVER: {
                        throw new UnimplementedError("Unexpected server function '" + funcNameStr + "' encountered in RPC dispatch");
                    }
                    case PROTOCOL: {
                        switch (this.protocolDispatcher.dispatch(dispatchMode, func, cmdEnv, paramMap)) {
                            case CONTINUE: {
                                continue block19;
                            }
                            case CONTINUE_LOOP: {
                                dispatchMode = RpcPacketDispatcherMode.LOOP;
                                continue block19;
                            }
                            case STOP_NORMAL: {
                                return resultsMapVec.toArray(new HashMap[resultsMapVec.size()]);
                            }
                        }
                        continue block19;
                    }
                }
                throw new ProtocolError("Unrecognized function string type in RPC packet: '" + funcNameStr + "'");
            }
            throw new ConnectionNotConnectedException("Perforce server disconnected at server end; unknown cause.");
        }
        catch (ConnectionNotConnectedException cnce) {
            throw cnce;
        }
        catch (Throwable thr) {
            Log.error("Unexpected exception: " + thr.getLocalizedMessage());
            Log.exception(thr);
            throw new ConnectionException(thr.getLocalizedMessage(), thr);
        }
    }

    public void shutdown(RpcConnection rpcConnection) throws ConnectionException {
        if (this.protocolDispatcher != null && rpcConnection != null) {
            try {
                this.protocolDispatcher.sendRelease2(rpcConnection);
            }
            catch (Exception exc) {
                Log.warn("Unexpected exception in RPC packet dispatch shutdown: " + exc.getLocalizedMessage());
                Log.exception(exc);
            }
        }
    }

    public FlowControl getFlowController() {
        return this.flowController;
    }

    protected void setFlowController(FlowControl flowController) {
        this.flowController = flowController;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RpcPacketDispatcherMode {
        NONE,
        PRIMAL,
        CALLBACK,
        LOOP,
        DUPLEX,
        DUPLEXREV;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RpcPacketDispatcherResult {
        NONE,
        CONTINUE,
        CONTINUE_LOOP,
        CONTINUE_DUPLEX,
        STOP_NORMAL,
        STOP_ERROR;

    }
}

