/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.func.client;

import com.perforce.p4java.exception.ConfigException;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.exception.TrustException;
import com.perforce.p4java.impl.mapbased.rpc.RpcServer;
import com.perforce.p4java.messages.PerforceMessages;
import com.perforce.p4java.server.Fingerprint;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

public class ClientTrust {
    public static final String DIGEST_TYPE = "SHA";
    public static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final String USER_NAME_PLACE_HOLDER = "**++**";
    public static final String CLIENT_TRUST_MESSAGES = "com.perforce.p4java.messages.ClientTrustMessages";
    public static final String CLIENT_TRUST_WARNING_NEW_CONNECTION = "client.trust.warning.newconnection";
    public static final String CLIENT_TRUST_WARNING_NEW_KEY = "client.trust.warning.newkey";
    public static final String CLIENT_TRUST_EXCEPTION_NEW_CONNECTION = "client.trust.exception.newconnection";
    public static final String CLIENT_TRUST_EXCEPTION_NEW_KEY = "client.trust.exception.newkey";
    public static final String CLIENT_TRUST_ADD_EXCEPTION_NEW_CONNECTION = "client.trust.add.exception.newconnection";
    public static final String CLIENT_TRUST_ADD_EXCEPTION_NEW_KEY = "client.trust.add.exception.newkey";
    public static final String CLIENT_TRUST_ADDED = "client.trust.added";
    public static final String CLIENT_TRUST_REMOVED = "client.trust.removed";
    public static final String CLIENT_TRUST_ALREADY_ESTABLISHED = "client.trust.alreadyestablished";
    public static final String CLIENT_TRUST_INSTALL_EXCEPTION = "client.trust.install.exception";
    public static final String CLIENT_TRUST_UNINSTALL_EXCEPTION = "client.trust.uninstall.exception";
    private RpcServer rpcServer = null;
    private PerforceMessages messages = new PerforceMessages("com.perforce.p4java.messages.ClientTrustMessages");

    public ClientTrust(RpcServer rpcServer) {
        if (rpcServer == null) {
            throw new NullPointerError("null rpcServer passed to ClientTrust constructor");
        }
        this.rpcServer = rpcServer;
    }

    public void installFingerprint(String serverIpPort, String fingerprint) throws TrustException {
        if (serverIpPort == null) {
            throw new NullPointerError("null serverIpPort passed to the ClientTrust installFingerprint method");
        }
        if (fingerprint == null) {
            throw new NullPointerError("null fingerprint passed to the ClientTrust installFingerprint method");
        }
        try {
            this.rpcServer.saveFingerprint(serverIpPort, fingerprint);
        }
        catch (ConfigException e) {
            throw new TrustException(TrustException.Type.INSTALL, this.rpcServer.getServerHostPort(), serverIpPort, fingerprint, this.messages.getMessage(CLIENT_TRUST_INSTALL_EXCEPTION, new Object[]{fingerprint, this.rpcServer.getServerHostPort(), serverIpPort}), e);
        }
    }

    public void removeFingerprint(String serverIpPort) throws TrustException {
        if (serverIpPort == null) {
            throw new NullPointerError("null serverIpPort passed to the ClientTrust removeFingerprint method");
        }
        try {
            this.rpcServer.saveFingerprint(serverIpPort, null);
        }
        catch (ConfigException e) {
            throw new TrustException(TrustException.Type.UNINSTALL, this.rpcServer.getServerHostPort(), serverIpPort, null, this.messages.getMessage(CLIENT_TRUST_UNINSTALL_EXCEPTION, new Object[]{this.rpcServer.getServerHostPort(), serverIpPort}), e);
        }
    }

    public boolean fingerprintExists(String serverIpPort) {
        if (serverIpPort == null) {
            throw new NullPointerError("null serverIpPort passed to the ClientTrust fingerprintExists method");
        }
        return this.rpcServer.loadFingerprint(serverIpPort) != null;
    }

    public boolean fingerprintMatches(String serverIpPort, String fingerprint) {
        Fingerprint existingFingerprint;
        if (serverIpPort == null) {
            throw new NullPointerError("null serverIpPort passed to the ClientTrust fingerprintMatches method");
        }
        if (fingerprint == null) {
            throw new NullPointerError("null fingerprint passed to the ClientTrust fingerprintMatches method");
        }
        return this.fingerprintExists(serverIpPort) && (existingFingerprint = this.rpcServer.loadFingerprint(serverIpPort)) != null && existingFingerprint.getFingerprintValue() != null && fingerprint.equalsIgnoreCase(existingFingerprint.getFingerprintValue());
    }

    public static String generateFingerprint(PublicKey publicKey) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(DIGEST_TYPE);
        md.update(publicKey.getEncoded());
        byte[] fp = md.digest();
        return ClientTrust.convert2Hex(fp);
    }

    public static String generateFingerprint(X509Certificate certificate) throws NoSuchAlgorithmException, CertificateEncodingException {
        MessageDigest md = MessageDigest.getInstance(DIGEST_TYPE);
        md.update(certificate.getEncoded());
        byte[] fp = md.digest();
        return ClientTrust.convert2Hex(fp);
    }

    public static String convert2Hex(byte[] data) {
        int n = data.length;
        StringBuffer sb = new StringBuffer(n * 3 - 1);
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                sb.append(':');
            }
            sb.append(HEX_CHARS[data[i] >> 4 & 0xF]);
            sb.append(HEX_CHARS[data[i] & 0xF]);
        }
        return sb.toString();
    }

    public PerforceMessages getMessages() {
        return this.messages;
    }
}

