/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.generic.core.file;

import com.perforce.p4java.Log;
import com.perforce.p4java.core.file.FileAction;
import com.perforce.p4java.core.file.FileSpecOpStatus;
import com.perforce.p4java.core.file.IExtendedFileSpec;
import com.perforce.p4java.core.file.IResolveRecord;
import com.perforce.p4java.impl.generic.core.file.FileSpec;
import com.perforce.p4java.impl.generic.core.file.ResolveRecord;
import com.perforce.p4java.server.IServer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedFileSpec
extends FileSpec
implements IExtendedFileSpec {
    private boolean mapped = false;
    private FileAction headAction = null;
    private int headChange = 0;
    private int headRev = 0;
    private String headType = null;
    private Date headTime = null;
    private Date headModTime = null;
    private int haveRev = 0;
    private String desc = null;
    private String digest = null;
    private long fileSize = 0L;
    private FileAction openAction = null;
    private String openType = null;
    private String openActionOwner = null;
    private int openChangelistId = 0;
    private boolean unresolved = false;
    private boolean resolved = false;
    private boolean otherLocked = false;
    private List<String> otherActionList = null;
    private List<String> otherChangelist = null;
    private List<String> otherOpenList = null;
    private String actionOwner = null;
    private boolean shelved = false;
    private List<IResolveRecord> resolveRecords = null;
    private String movedFile = null;
    private Map<String, byte[]> attributes = null;

    public ExtendedFileSpec() {
    }

    public ExtendedFileSpec(Map<String, Object> map, IServer server, int index) {
        super(map, server, index);
        if (map != null) {
            try {
                this.setClient(null);
                this.setMapped(map.get("isMapped") != null);
                this.setHeadAction(FileAction.fromString((String)map.get("headAction")));
                String cList = (String)map.get("headChange");
                if (cList != null && !cList.equalsIgnoreCase("default")) {
                    this.setHeadChange(new Integer(cList));
                } else {
                    this.setHeadChange(0);
                }
                this.setHeadRev(map.get("headRev") == null ? 0 : new Integer((String)map.get("headRev")));
                this.setHeadType((String)map.get("headType"));
                this.setHeadTime(map.get("headTime") == null ? null : new Date(Long.parseLong((String)map.get("headTime")) * 1000L));
                this.setHeadModTime(map.get("headModTime") == null ? null : new Date(Long.parseLong((String)map.get("headModTime")) * 1000L));
                this.setHaveRev(ExtendedFileSpec.getRevFromString((String)map.get("haveRev")));
                this.setDesc((String)map.get("desc"));
                this.setDigest((String)map.get("digest"));
                this.setFileSize(map.get("fileSize") == null ? 0L : new Long((String)map.get("fileSize")));
                this.setOpenAction(map.get("openAction") == null ? null : FileAction.fromString((String)map.get("openAction")));
                this.setOpenType((String)map.get("openType"));
                this.setOpenActionOwner((String)map.get("openActionOwner"));
                this.setOpenChangelistId(map.get("openChangelist") == null ? 0 : new Integer((String)map.get("openChangelist")));
                this.setResolved(map.get("resolved") != null);
                this.setUnresolved(map.get("unresolved") != null);
                this.setOtherLocked(map.get("otherLock") != null);
                this.setOtherActionList(this.getStringList(map, "otherAction"));
                this.setOtherChangelist(this.getStringList(map, "otherChange"));
                this.setOtherOpenList(this.getStringList(map, "otherOpen"));
                this.setActionOwner((String)map.get("actionOwner"));
                this.shelved = map.containsKey("shelved");
                this.movedFile = (String)map.get("movedFile");
                int i = 0;
                while (map.containsKey("resolveAction" + i)) {
                    if (this.resolveRecords == null) {
                        this.resolveRecords = new ArrayList<IResolveRecord>();
                    }
                    this.resolveRecords.add(new ResolveRecord(map, i));
                    ++i;
                }
                for (String key : map.keySet()) {
                    int i2;
                    if (key == null || !key.startsWith("attr-") && !key.startsWith("openattr-")) continue;
                    if (this.attributes == null) {
                        this.attributes = new HashMap<String, byte[]>();
                    }
                    if ((i2 = key.indexOf("-")) >= key.length()) continue;
                    String name = key.substring(i2 + 1);
                    try {
                        Object object = map.get(key);
                        if (object instanceof String) {
                            this.attributes.put(name, ((String)object).getBytes());
                            continue;
                        }
                        this.attributes.put(name, (byte[])object);
                    }
                    catch (Throwable thr) {
                        Log.warn("Unexpected exception in ExtendedFileSpec file attributes processing");
                        Log.exception(thr);
                    }
                }
            }
            catch (Exception exc) {
                Log.error("Unexpected exception in ExtendedFileSpec constructor" + exc.getLocalizedMessage());
                Log.exception(exc);
            }
        }
    }

    public ExtendedFileSpec(FileSpecOpStatus status, String errStr) {
        super(status, errStr);
    }

    public ExtendedFileSpec(FileSpecOpStatus status, String errStr, int genericCode, int severityCode) {
        super(status, errStr, genericCode, severityCode);
    }

    public ExtendedFileSpec(FileSpecOpStatus status, String errStr, String errCodeStr) {
        super(status, errStr, errCodeStr);
    }

    public ExtendedFileSpec(FileSpecOpStatus status, String errStr, int rawCode) {
        super(status, errStr, rawCode);
    }

    public ExtendedFileSpec(String pathStr) {
        super(pathStr);
    }

    @Override
    public String getDesc() {
        return this.desc;
    }

    @Override
    public String getDigest() {
        return this.digest;
    }

    @Override
    public long getFileSize() {
        return this.fileSize;
    }

    @Override
    public int getHaveRev() {
        return this.haveRev;
    }

    @Override
    public FileAction getHeadAction() {
        return this.headAction;
    }

    @Override
    public int getHeadChange() {
        return this.headChange;
    }

    @Override
    public Date getHeadModTime() {
        return this.headModTime;
    }

    @Override
    public int getHeadRev() {
        return this.headRev;
    }

    @Override
    public Date getHeadTime() {
        return this.headTime;
    }

    @Override
    public String getHeadType() {
        return this.headType;
    }

    @Override
    public FileAction getOpenAction() {
        return this.openAction;
    }

    @Override
    public String getOpenActionOwner() {
        return this.openActionOwner;
    }

    @Override
    public int getOpenChangelistId() {
        return this.openChangelistId;
    }

    @Override
    public String getOpenType() {
        return this.openType;
    }

    @Override
    public boolean isMapped() {
        return this.mapped;
    }

    @Override
    public boolean isResolved() {
        return this.resolved;
    }

    @Override
    public boolean isUnresolved() {
        return this.unresolved;
    }

    @Override
    public boolean isOtherLocked() {
        return this.otherLocked;
    }

    @Override
    public List<String> getOtherOpenList() {
        return this.otherOpenList;
    }

    @Override
    public List<String> getOtherChangelist() {
        return this.otherChangelist;
    }

    @Override
    public List<String> getOtherActionList() {
        return this.otherActionList;
    }

    @Override
    public void setMapped(boolean mapped) {
        this.mapped = mapped;
    }

    @Override
    public void setHeadAction(FileAction headAction) {
        this.headAction = headAction;
    }

    @Override
    public void setHeadChange(int headChange) {
        this.headChange = headChange;
    }

    @Override
    public void setHeadRev(int headRev) {
        this.headRev = headRev;
    }

    @Override
    public void setHeadType(String headType) {
        this.headType = headType;
    }

    @Override
    public void setHeadTime(Date headTime) {
        this.headTime = headTime;
    }

    @Override
    public void setHeadModTime(Date headModTime) {
        this.headModTime = headModTime;
    }

    @Override
    public void setHaveRev(int haveRev) {
        this.haveRev = haveRev;
    }

    @Override
    public void setDesc(String desc) {
        this.desc = desc;
    }

    @Override
    public void setDigest(String digest) {
        this.digest = digest;
    }

    @Override
    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    @Override
    public void setOpenAction(FileAction openAction) {
        this.openAction = openAction;
    }

    @Override
    public void setOpenType(String openType) {
        this.openType = openType;
    }

    @Override
    public void setOpenActionOwner(String openActionOwner) {
        this.openActionOwner = openActionOwner;
    }

    @Override
    public void setOpenChangelistId(int openChangelistId) {
        this.openChangelistId = openChangelistId;
    }

    @Override
    public void setUnresolved(boolean unresolved) {
        this.unresolved = unresolved;
    }

    @Override
    public void setResolved(boolean resolved) {
        this.resolved = resolved;
    }

    @Override
    public void setOtherLocked(boolean otherLocked) {
        this.otherLocked = otherLocked;
    }

    @Override
    public void setOtherOpenList(List<String> otherOpenList) {
        this.otherOpenList = otherOpenList;
    }

    @Override
    public void setOtherChangelist(List<String> otherChangelist) {
        this.otherChangelist = otherChangelist;
    }

    @Override
    public void setOtherActionList(List<String> otherActionList) {
        this.otherActionList = otherActionList;
    }

    private List<String> getStringList(Map<String, Object> map, String key) {
        ArrayList<String> strList = null;
        if (map != null && key != null) {
            int i = 0;
            while (map.containsKey(key + i)) {
                if (strList == null) {
                    strList = new ArrayList<String>();
                }
                strList.add((String)map.get(key + i));
                ++i;
            }
        }
        return strList;
    }

    @Override
    public String getActionOwner() {
        return this.actionOwner;
    }

    @Override
    public void setActionOwner(String actionOwner) {
        this.actionOwner = actionOwner;
    }

    @Override
    public boolean isShelved() {
        return this.shelved;
    }

    @Override
    public List<IResolveRecord> getResolveRecords() {
        return this.resolveRecords;
    }

    @Override
    public void setResolveRecords(List<IResolveRecord> resolveRecords) {
        this.resolveRecords = resolveRecords;
    }

    @Override
    public String getMovedFile() {
        return this.movedFile;
    }

    @Override
    public void setMovedFile(String movedFile) {
        this.movedFile = movedFile;
    }

    @Override
    public Map<String, byte[]> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, byte[]>();
        }
        return this.attributes;
    }
}

