/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.generic.core;

import com.perforce.p4java.client.IClient;
import com.perforce.p4java.core.ChangelistStatus;
import com.perforce.p4java.core.IChangelist;
import com.perforce.p4java.core.IChangelistSummary;
import com.perforce.p4java.core.IFix;
import com.perforce.p4java.core.IJob;
import com.perforce.p4java.core.file.DiffType;
import com.perforce.p4java.core.file.FileSpecOpStatus;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.exception.UnimplementedError;
import com.perforce.p4java.impl.generic.core.ChangelistSummary;
import com.perforce.p4java.impl.generic.core.InputMapper;
import com.perforce.p4java.impl.generic.core.file.FileSpec;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.Server;
import com.perforce.p4java.option.Options;
import com.perforce.p4java.option.changelist.SubmitOptions;
import com.perforce.p4java.option.server.GetChangelistDiffsOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IServer;
import com.perforce.p4java.server.callback.IStreamingCallback;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Changelist
extends ChangelistSummary
implements IChangelist {
    protected Server serverImpl = null;
    protected List<IFileSpec> fileSpecs = null;
    protected List<String> jobIds = null;
    public static final String DEFAULT_DESCRIPTION = "New changelist created by P4Java";

    public static Changelist newChangelist(IServer server, String clientName, String description) {
        if (server == null) {
            throw new NullPointerError("null server passed to Changelist.newChangelist");
        }
        if (!(server instanceof Server)) {
            throw new P4JavaError("IOptionsServer passed to Changelist.newChangelist does not implement 'Server' class");
        }
        if (clientName == null) {
            throw new NullPointerError("null client name passed to Changelist.newChangelist");
        }
        return new Changelist(-1, clientName, server.getUserName(), ChangelistStatus.NEW, null, description == null ? DEFAULT_DESCRIPTION : description, false, (Server)server);
    }

    public static Changelist newChangelist(IClient client, String description) {
        if (client == null) {
            throw new NullPointerError("null client passed to Changelist.newChangelist");
        }
        if (client.getServer() == null) {
            throw new NullPointerError("client has no server associated with it in Changelist.newChangelist");
        }
        return Changelist.newChangelist(client.getServer(), client.getName(), description);
    }

    public Changelist() {
    }

    public Changelist(int id, String clientId, String username, ChangelistStatus status, Date date, String description, boolean shelved, Server serverImpl) {
        super(false, true, true, true, serverImpl);
        this.id = id;
        this.clientId = clientId;
        this.username = username;
        this.status = status;
        this.date = date;
        this.description = description;
        this.shelved = shelved;
        this.serverImpl = serverImpl;
    }

    public Changelist(int id, String clientId, String username, ChangelistStatus status, Date date, String description, boolean shelved, Server serverImpl, IChangelistSummary.Visibility visibility) {
        super(false, true, true, true, serverImpl);
        this.id = id;
        this.clientId = clientId;
        this.username = username;
        this.status = status;
        this.date = date;
        this.description = description;
        this.shelved = shelved;
        this.serverImpl = serverImpl;
        this.visibility = visibility;
    }

    public Changelist(IChangelistSummary summary, IServer server, boolean refresh) throws ConnectionException, RequestException, AccessException {
        super(summary);
        super.setRefreshable(true);
        this.updateable = true;
        this.server = server;
        if (server instanceof Server) {
            this.serverImpl = (Server)server;
        }
        if (summary != null && server != null && refresh) {
            this.refresh();
        }
    }

    public Changelist(Map<String, Object> map, Server serverImpl) {
        super(map, false, (IServer)serverImpl);
        this.serverImpl = serverImpl;
        if (map != null && map.containsKey("Jobs0")) {
            String jobId;
            this.jobIds = new ArrayList<String>();
            for (int job = 0; job >= 0 && (jobId = (String)map.get("Jobs" + job)) != null; ++job) {
                this.jobIds.add(jobId);
            }
        }
    }

    @Override
    public boolean isShelved() {
        return this.shelved;
    }

    @Override
    public void setShelved(boolean shelved) {
        this.shelved = shelved;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public ChangelistStatus getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(ChangelistStatus status) {
        this.status = status;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public void setDate(Date date) {
        this.date = date;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String setDescription(String description) {
        String oldVal = this.description;
        this.description = description;
        return oldVal;
    }

    public IServer getServer() {
        return this.serverImpl;
    }

    public void setServerImpl(Server serverImpl) {
        this.serverImpl = serverImpl;
    }

    @Override
    public List<IFileSpec> getFiles(boolean refresh) throws ConnectionException, RequestException, AccessException {
        return this.getFiles(refresh, false);
    }

    public List<IFileSpec> getFiles(boolean refresh, boolean bypassServer) throws ConnectionException, RequestException, AccessException {
        if (!refresh && this.fileSpecs != null) {
            return this.fileSpecs;
        }
        if (bypassServer && !refresh && this.fileSpecs == null) {
            this.fileSpecs = new ArrayList<IFileSpec>();
            return this.fileSpecs;
        }
        if (this.serverImpl == null) {
            throw new RequestException("Changelist not associated with a Perforce server");
        }
        if (this.id == 0) {
            List<IFileSpec> openList = this.serverImpl.getOpenedFiles(null, false, this.clientId, 0, 0);
            ArrayList<IFileSpec> defList = new ArrayList<IFileSpec>();
            if (openList != null) {
                for (IFileSpec fSpec : openList) {
                    if (fSpec.getChangelistId() != 0) continue;
                    defList.add(fSpec);
                }
            }
            this.fileSpecs = defList;
        } else {
            this.fileSpecs = this.serverImpl.getChangelistFiles(this.id);
        }
        return this.fileSpecs;
    }

    @Override
    public InputStream getDiffs(DiffType diffType) throws ConnectionException, RequestException, AccessException {
        if (this.serverImpl == null) {
            throw new RequestException("Changelist not associated with a Perforce server");
        }
        return this.serverImpl.getChangelistDiffs(this.id, diffType);
    }

    @Override
    public InputStream getDiffsStream(GetChangelistDiffsOptions opts) throws P4JavaException {
        if (this.serverImpl == null) {
            throw new RequestException("Changelist not associated with a Perforce server");
        }
        return this.serverImpl.getChangelistDiffs(this.id, opts);
    }

    @Override
    public List<String> getJobIds() throws ConnectionException, RequestException, AccessException {
        List<IFix> fixList;
        ArrayList<String> idList = new ArrayList<String>();
        if (this.serverImpl != null && this.id != -1 && (fixList = this.serverImpl.getFixList(null, this.id, null, false, 0)) != null) {
            for (IFix fix : fixList) {
                if (fix == null || fix.getJobId() == null) continue;
                idList.add(fix.getJobId());
            }
            this.jobIds = idList;
        }
        return idList;
    }

    @Override
    public List<String> getCachedJobIdList() throws ConnectionException, RequestException, AccessException {
        if (this.jobIds != null) {
            return this.jobIds;
        }
        return new ArrayList<String>();
    }

    @Override
    public List<IJob> getJobs() throws ConnectionException, RequestException, AccessException {
        List<String> idList = this.getJobIds();
        ArrayList<IJob> jobList = new ArrayList<IJob>();
        if (idList != null && this.serverImpl != null) {
            for (String id : idList) {
                jobList.add(this.serverImpl.getJob(id));
            }
        }
        return jobList;
    }

    @Override
    public List<IFileSpec> submit(boolean reOpen, List<String> jobIds, String jobStatus) throws ConnectionException, RequestException, AccessException {
        try {
            return this.submit(new SubmitOptions().setJobIds(jobIds).setJobStatus(jobStatus).setReOpen(reOpen));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public List<IFileSpec> submit(SubmitOptions opts) throws P4JavaException {
        if (this.serverImpl == null) {
            throw new RequestException("Changelist not associated with a Perforce server");
        }
        Map<String, Object> inMap = this.getInMap(opts);
        Map<String, Object>[] resultsMap = this.serverImpl.execMapCmd(CmdSpec.SUBMIT, Parameters.processParameters((Options)opts, null, "-i", (IServer)this.serverImpl), inMap);
        ArrayList<IFileSpec> fileList = new ArrayList<IFileSpec>();
        if (resultsMap != null) {
            for (Map<String, Object> map : resultsMap) {
                if (map.get("submittedChange") != null) {
                    this.id = new Integer((String)map.get("submittedChange"));
                    this.status = ChangelistStatus.SUBMITTED;
                    fileList.add(new FileSpec(FileSpecOpStatus.INFO, "Submitted as change " + this.id));
                    continue;
                }
                if (map.get("locked") != null) continue;
                fileList.add(this.serverImpl.handleFileReturn(map));
            }
        }
        return fileList;
    }

    @Override
    public void submit(SubmitOptions opts, IStreamingCallback callback, int key) throws P4JavaException {
        if (this.serverImpl == null) {
            throw new RequestException("Changelist not associated with a Perforce server");
        }
        Map<String, Object> inMap = this.getInMap(opts);
        this.serverImpl.execStreamingMapCommand(CmdSpec.SUBMIT.toString(), Parameters.processParameters((Options)opts, null, "-i", (IServer)this.serverImpl), inMap, callback, key);
    }

    @Override
    public List<IFileSpec> submit(boolean reOpen) throws ConnectionException, RequestException, AccessException {
        return this.submit(reOpen, null, null);
    }

    private void updateFlags() {
    }

    private Map<String, Object> getInMap(SubmitOptions opts) throws P4JavaException {
        HashMap<String, Object> inMap;
        block11: {
            int i;
            block10: {
                inMap = new HashMap<String, Object>();
                if (this.id == -1 || this.id == 0) {
                    inMap.put("Change", "new");
                } else {
                    inMap.put("Change", Integer.toString(this.id));
                }
                inMap.put("Client", this.clientId);
                inMap.put("User", this.username);
                inMap.put("Description", this.description);
                if (this.fileSpecs == null || this.fileSpecs.isEmpty()) {
                    this.getFiles(true);
                }
                if (this.fileSpecs != null) {
                    i = 0;
                    for (IFileSpec spec : this.fileSpecs) {
                        inMap.put("Files" + i++, spec.getDepotPathString());
                    }
                }
                if (this.id != -1 && this.id != 0 && this.id > 0) {
                    this.getJobIds();
                }
                if (opts == null || opts.getJobIds() == null) break block10;
                i = 0;
                for (String id : opts.getJobIds()) {
                    if (opts.getJobStatus() != null) {
                        inMap.put("Jobs" + i++, id + " " + opts.getJobStatus());
                        continue;
                    }
                    inMap.put("Jobs" + i++, id);
                }
                break block11;
            }
            if (this.jobIds == null) break block11;
            i = 0;
            for (String id : this.jobIds) {
                if (opts != null && opts.getJobStatus() != null) {
                    inMap.put("Jobs" + i++, id + " " + opts.getJobStatus());
                    continue;
                }
                inMap.put("Jobs" + i++, id);
            }
        }
        return inMap;
    }

    @Override
    public void refresh() throws ConnectionException, RequestException, AccessException {
        if (this.serverImpl == null) {
            throw new RequestException("Changelist not associated with a Perforce server");
        }
        if (!this.refreshable) {
            throw new UnimplementedError("tried to refresh non-refreshable changelist");
        }
        IChangelist cList = this.serverImpl.getChangelist(this.id);
        this.status = cList.getStatus();
        this.clientId = cList.getClientId();
        this.date = cList.getDate();
        this.description = cList.getDescription();
        this.username = cList.getUsername();
        this.jobIds = cList.getCachedJobIdList();
        this.getFiles(true);
        this.updateFlags();
    }

    @Override
    public void update() throws ConnectionException, RequestException, AccessException {
        this.update(false);
    }

    @Override
    public void update(boolean force) throws ConnectionException, RequestException, AccessException {
        Map<String, Object>[] changeMap;
        if (this.serverImpl == null) {
            throw new RequestException("Changelist not associated with a Perforce server");
        }
        if (!this.updateable) {
            throw new UnimplementedError("tried to refresh non-updateable changelist");
        }
        if (this.id == -1 || this.id == 0) {
            throw new RequestException("Tried to update new or default changelist");
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add("-i");
        if (force) {
            args.add("-f");
        }
        if ((changeMap = this.serverImpl.execMapCmd(CmdSpec.CHANGE, args.toArray(new String[args.size()]), InputMapper.map(this))) != null) {
            for (Map<String, Object> map : changeMap) {
                this.serverImpl.handleErrorStr(map);
            }
        }
    }

    @Override
    public void updateOnServer(boolean refresh) throws ConnectionException, RequestException, AccessException {
        this.update();
        if (refresh) {
            this.refresh();
        }
    }

    public List<IFileSpec> getFileSpecs() {
        return this.fileSpecs;
    }

    public void setFileSpecs(List<IFileSpec> fileSpecs) {
        this.fileSpecs = fileSpecs;
    }
}

