/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.util.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class OpenOnReadFileInputStream
extends InputStream {
    private final File file;
    private InputStream in;

    public OpenOnReadFileInputStream(File file) {
        this.file = file;
    }

    private void ensureOpen() throws IOException {
        if (this.in == null) {
            this.in = new FileInputStream(this.file);
        }
    }

    @Override
    public void close() throws IOException {
        this.ensureOpen();
        this.in.close();
    }

    @Override
    public int available() throws IOException {
        this.ensureOpen();
        return this.in.available();
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        return this.in.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        return this.in.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.ensureOpen();
        return this.in.read(b);
    }

    @Override
    public long skip(long n) throws IOException {
        this.ensureOpen();
        return this.in.skip(n);
    }
}

