/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.util.generic;

import org.robovm.compiler.util.generic.ListOfTypes;
import org.robovm.compiler.util.generic.ParameterizedType;
import org.robovm.compiler.util.generic.SootClassType;
import org.robovm.compiler.util.generic.Type;

public final class ImplForType
implements ParameterizedType {
    private final ListOfTypes args;
    private final ImplForType ownerType0;
    private Type ownerTypeRes;
    private SootClassType rawType;
    private final String rawTypeName;

    public ImplForType(ImplForType ownerType, String rawTypeName, ListOfTypes args) {
        this.ownerType0 = ownerType;
        this.rawTypeName = rawTypeName;
        this.args = args;
    }

    @Override
    public Type[] getActualTypeArguments() {
        return (Type[])this.args.getResolvedTypes().clone();
    }

    @Override
    public Type getOwnerType() {
        if (this.ownerTypeRes == null) {
            this.ownerTypeRes = this.ownerType0 != null ? this.ownerType0.getResolvedType() : this.getRawType().getDeclaringClass();
        }
        return this.ownerTypeRes;
    }

    @Override
    public SootClassType getRawType() {
        if (this.rawType == null) {
            this.rawType = new SootClassType(this.rawTypeName);
        }
        return this.rawType;
    }

    Type getResolvedType() {
        if (this.args.getResolvedTypes().length == 0) {
            return this.getRawType();
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.rawTypeName);
        if (this.args.length() > 0) {
            sb.append("<").append(this.args).append(">");
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ImplForType)) {
            return false;
        }
        ImplForType that = (ImplForType)obj;
        return this.args.equals(that.args) && this.getRawType().equals(that.getRawType());
    }

    private String getSignature() {
        StringBuilder sb = new StringBuilder();
        Type declaringClass = this.getOwnerType();
        if (declaringClass instanceof ImplForType) {
            ImplForType owner = (ImplForType)declaringClass;
            sb.append(owner.getSignature());
            sb.append('.');
            String innerName = this.rawTypeName.substring(owner.rawTypeName.length() + 1);
            sb.append(innerName);
        } else {
            sb.append(this.rawTypeName.replace('.', '/'));
        }
        Type[] typeArgs = this.getActualTypeArguments();
        if (typeArgs.length > 0) {
            sb.append("<");
            for (Type ta : typeArgs) {
                sb.append(ta.toGenericSignature());
            }
            sb.append(">");
        }
        return sb.toString();
    }

    @Override
    public String toGenericSignature() {
        return "L" + this.getSignature() + ";";
    }
}

