/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.util.generic;

import java.lang.reflect.GenericSignatureFormatError;
import org.robovm.compiler.util.generic.GenericDeclaration;
import org.robovm.compiler.util.generic.ImplForArray;
import org.robovm.compiler.util.generic.ImplForType;
import org.robovm.compiler.util.generic.ImplForVariable;
import org.robovm.compiler.util.generic.ImplForWildcard;
import org.robovm.compiler.util.generic.ListOfTypes;
import org.robovm.compiler.util.generic.ListOfVariables;
import org.robovm.compiler.util.generic.SootClassType;
import org.robovm.compiler.util.generic.SootConstructorType;
import org.robovm.compiler.util.generic.SootMethodType;
import org.robovm.compiler.util.generic.SootTypeType;
import org.robovm.compiler.util.generic.Type;
import org.robovm.compiler.util.generic.TypeVariable;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.LongType;
import soot.ShortType;
import soot.VoidType;
import soot.tagkit.SignatureTag;

public class GenericSignatureParser {
    public ListOfTypes exceptionTypes;
    public ListOfTypes parameterTypes;
    public TypeVariable[] formalTypeParameters;
    public Type returnType;
    public Type fieldType;
    public ListOfTypes interfaceTypes;
    public Type superclassType;
    GenericDeclaration genericDecl;
    char symbol;
    String identifier;
    private boolean eof;
    char[] buffer;
    int pos;

    void setInput(GenericDeclaration genericDecl, SignatureTag input) {
        if (input != null) {
            this.genericDecl = genericDecl;
            this.buffer = input.getSignature().toCharArray();
            this.eof = false;
            this.scanSymbol();
        } else {
            this.eof = true;
        }
    }

    public void parseForClass(GenericDeclaration genericDecl, SignatureTag signature) {
        this.setInput(genericDecl, signature);
        if (!this.eof) {
            this.parseClassSignature();
        } else if (genericDecl instanceof SootClassType) {
            SootClassType c = (SootClassType)genericDecl;
            this.formalTypeParameters = ListOfVariables.EMPTY;
            this.superclassType = c.getSuperclass();
            this.interfaceTypes = new ListOfTypes(c.getInterfaces());
        } else {
            this.formalTypeParameters = ListOfVariables.EMPTY;
            this.superclassType = new SootClassType("java.lang.Object");
            this.interfaceTypes = ListOfTypes.EMPTY;
        }
    }

    public void parseForMethod(GenericDeclaration genericDecl, SignatureTag signature, SootClassType[] rawExceptionTypes) {
        this.setInput(genericDecl, signature);
        if (!this.eof) {
            this.parseMethodTypeSignature(rawExceptionTypes);
        } else if (genericDecl instanceof SootMethodType) {
            SootMethodType m = (SootMethodType)genericDecl;
            this.formalTypeParameters = ListOfVariables.EMPTY;
            this.parameterTypes = new ListOfTypes(m.getParameterTypes());
            this.exceptionTypes = new ListOfTypes(m.getExceptionTypes());
            this.returnType = m.getReturnType();
        } else {
            this.formalTypeParameters = ListOfVariables.EMPTY;
            this.parameterTypes = ListOfTypes.EMPTY;
            this.exceptionTypes = ListOfTypes.EMPTY;
            this.returnType = new SootTypeType((soot.Type)VoidType.v());
        }
    }

    public void parseForConstructor(GenericDeclaration genericDecl, SignatureTag signature, SootClassType[] rawExceptionTypes) {
        this.setInput(genericDecl, signature);
        if (!this.eof) {
            this.parseMethodTypeSignature(rawExceptionTypes);
        } else if (genericDecl instanceof SootConstructorType) {
            SootConstructorType c = (SootConstructorType)genericDecl;
            this.formalTypeParameters = ListOfVariables.EMPTY;
            this.parameterTypes = new ListOfTypes(c.getParameterTypes());
            this.exceptionTypes = new ListOfTypes(c.getExceptionTypes());
        } else {
            this.formalTypeParameters = ListOfVariables.EMPTY;
            this.parameterTypes = ListOfTypes.EMPTY;
            this.exceptionTypes = ListOfTypes.EMPTY;
        }
    }

    public void parseForField(GenericDeclaration genericDecl, SignatureTag signature) {
        this.setInput(genericDecl, signature);
        if (!this.eof) {
            this.fieldType = this.parseFieldTypeSignature();
        }
    }

    void parseClassSignature() {
        this.parseOptFormalTypeParameters();
        this.superclassType = this.parseClassTypeSignature();
        this.interfaceTypes = new ListOfTypes(16);
        while (this.symbol > '\u0000') {
            this.interfaceTypes.add(this.parseClassTypeSignature());
        }
    }

    void parseOptFormalTypeParameters() {
        ListOfVariables typeParams = new ListOfVariables();
        if (this.symbol == '<') {
            this.scanSymbol();
            typeParams.add(this.parseFormalTypeParameter());
            while (this.symbol != '>' && this.symbol > '\u0000') {
                typeParams.add(this.parseFormalTypeParameter());
            }
            this.expect('>');
        }
        this.formalTypeParameters = typeParams.getArray();
    }

    ImplForVariable<GenericDeclaration> parseFormalTypeParameter() {
        this.scanIdentifier();
        String name = this.identifier.intern();
        ListOfTypes bounds = new ListOfTypes(8);
        this.expect(':');
        if (this.symbol == 'L' || this.symbol == '[' || this.symbol == 'T') {
            bounds.add(this.parseFieldTypeSignature());
        }
        while (this.symbol == ':') {
            this.scanSymbol();
            bounds.add(this.parseFieldTypeSignature());
        }
        return new ImplForVariable<GenericDeclaration>(this.genericDecl, name, bounds);
    }

    Type parseFieldTypeSignature() {
        switch (this.symbol) {
            case 'L': {
                return this.parseClassTypeSignature();
            }
            case '[': {
                this.scanSymbol();
                return new ImplForArray(this.parseTypeSignature());
            }
            case 'T': {
                return this.parseTypeVariableSignature();
            }
        }
        throw new GenericSignatureFormatError();
    }

    Type parseClassTypeSignature() {
        ImplForType parentType;
        this.expect('L');
        StringBuilder qualIdent = new StringBuilder();
        this.scanIdentifier();
        while (this.symbol == '/') {
            this.scanSymbol();
            qualIdent.append(this.identifier).append(".");
            this.scanIdentifier();
        }
        qualIdent.append(this.identifier);
        ListOfTypes typeArgs = this.parseOptTypeArguments();
        ImplForType type = parentType = new ImplForType(null, qualIdent.toString(), typeArgs);
        while (this.symbol == '.') {
            this.scanSymbol();
            this.scanIdentifier();
            qualIdent.append("$").append(this.identifier);
            typeArgs = this.parseOptTypeArguments();
            type = new ImplForType(parentType, qualIdent.toString(), typeArgs);
        }
        this.expect(';');
        return type;
    }

    ListOfTypes parseOptTypeArguments() {
        ListOfTypes typeArgs = new ListOfTypes(8);
        if (this.symbol == '<') {
            this.scanSymbol();
            typeArgs.add(this.parseTypeArgument());
            while (this.symbol != '>' && this.symbol > '\u0000') {
                typeArgs.add(this.parseTypeArgument());
            }
            this.expect('>');
        }
        return typeArgs;
    }

    Type parseTypeArgument() {
        ListOfTypes extendsBound = new ListOfTypes(1);
        ListOfTypes superBound = new ListOfTypes(1);
        if (this.symbol == '*') {
            this.scanSymbol();
            extendsBound.add(new SootClassType("java.lang.Object"));
            return new ImplForWildcard(extendsBound, superBound);
        }
        if (this.symbol == '+') {
            this.scanSymbol();
            extendsBound.add(this.parseFieldTypeSignature());
            return new ImplForWildcard(extendsBound, superBound);
        }
        if (this.symbol == '-') {
            this.scanSymbol();
            superBound.add(this.parseFieldTypeSignature());
            extendsBound.add(new SootClassType("java.lang.Object"));
            return new ImplForWildcard(extendsBound, superBound);
        }
        return this.parseFieldTypeSignature();
    }

    ImplForVariable<GenericDeclaration> parseTypeVariableSignature() {
        this.expect('T');
        this.scanIdentifier();
        this.expect(';');
        return new ImplForVariable<GenericDeclaration>(this.genericDecl, this.identifier);
    }

    Type parseTypeSignature() {
        switch (this.symbol) {
            case 'B': {
                this.scanSymbol();
                return new SootTypeType((soot.Type)ByteType.v());
            }
            case 'C': {
                this.scanSymbol();
                return new SootTypeType((soot.Type)CharType.v());
            }
            case 'D': {
                this.scanSymbol();
                return new SootTypeType((soot.Type)DoubleType.v());
            }
            case 'F': {
                this.scanSymbol();
                return new SootTypeType((soot.Type)FloatType.v());
            }
            case 'I': {
                this.scanSymbol();
                return new SootTypeType((soot.Type)IntType.v());
            }
            case 'J': {
                this.scanSymbol();
                return new SootTypeType((soot.Type)LongType.v());
            }
            case 'S': {
                this.scanSymbol();
                return new SootTypeType((soot.Type)ShortType.v());
            }
            case 'Z': {
                this.scanSymbol();
                return new SootTypeType((soot.Type)BooleanType.v());
            }
        }
        return this.parseFieldTypeSignature();
    }

    void parseMethodTypeSignature(SootClassType[] rawExceptionTypes) {
        this.parseOptFormalTypeParameters();
        this.parameterTypes = new ListOfTypes(16);
        this.expect('(');
        while (this.symbol != ')' && this.symbol > '\u0000') {
            this.parameterTypes.add(this.parseTypeSignature());
        }
        this.expect(')');
        this.returnType = this.parseReturnType();
        if (this.symbol == '^') {
            this.exceptionTypes = new ListOfTypes(8);
            do {
                this.scanSymbol();
                if (this.symbol == 'T') {
                    this.exceptionTypes.add(this.parseTypeVariableSignature());
                    continue;
                }
                this.exceptionTypes.add(this.parseClassTypeSignature());
            } while (this.symbol == '^');
        } else {
            this.exceptionTypes = rawExceptionTypes != null ? new ListOfTypes(rawExceptionTypes) : new ListOfTypes(0);
        }
    }

    Type parseReturnType() {
        if (this.symbol != 'V') {
            return this.parseTypeSignature();
        }
        this.scanSymbol();
        return new SootTypeType((soot.Type)VoidType.v());
    }

    void scanSymbol() {
        if (!this.eof) {
            if (this.pos < this.buffer.length) {
                this.symbol = this.buffer[this.pos];
                ++this.pos;
            } else {
                this.symbol = '\u0000';
                this.eof = true;
            }
        } else {
            throw new GenericSignatureFormatError();
        }
    }

    void expect(char c) {
        if (this.symbol != c) {
            throw new GenericSignatureFormatError();
        }
        this.scanSymbol();
    }

    boolean isStopSymbol(char ch) {
        switch (ch) {
            case '.': 
            case '/': 
            case ':': 
            case ';': 
            case '<': {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void scanIdentifier() {
        if (this.eof) throw new GenericSignatureFormatError();
        StringBuilder identBuf = new StringBuilder(32);
        if (!this.isStopSymbol(this.symbol)) {
            identBuf.append(this.symbol);
            do {
                char ch;
                if ((ch = this.buffer[this.pos]) >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || !this.isStopSymbol(ch)) {
                    identBuf.append(this.buffer[this.pos]);
                    ++this.pos;
                    continue;
                }
                this.identifier = identBuf.toString();
                this.scanSymbol();
                return;
            } while (this.pos != this.buffer.length);
        } else {
            this.symbol = '\u0000';
            this.eof = true;
            throw new GenericSignatureFormatError();
        }
        this.identifier = identBuf.toString();
        this.symbol = '\u0000';
        this.eof = true;
    }
}

