/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DigestUtil {
    private static final String HEX_CHARS = "0123456789abcdef";

    private static MessageDigest getDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new Error("Could not find MessageDigest algorithm " + algorithm, ex);
        }
    }

    public static String sha1(String s) {
        try {
            return DigestUtil.encodeHex(DigestUtil.digest("SHA1", s.getBytes("utf8")));
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    private static byte[] digest(String algorithm, byte[] bytes) {
        return DigestUtil.getDigest(algorithm).digest(bytes);
    }

    private static String encodeHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            int b = bytes[i] & 0xFF;
            sb.append(HEX_CHARS.charAt(b >> 4 & 0xF));
            sb.append(HEX_CHARS.charAt(b & 0xF));
        }
        return sb.toString();
    }
}

