/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.target.ios;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.exec.util.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.robovm.compiler.config.Arch;
import org.robovm.compiler.config.CpuArch;
import org.robovm.compiler.config.Environment;
import org.robovm.compiler.log.Logger;
import org.robovm.compiler.util.Executor;

public class DeviceType
implements Comparable<DeviceType> {
    public static final String IOS_VERSION_PREFIX = "com.apple.CoreSimulator.SimRuntime.iOS-";
    public static final String PREFERRED_IPHONE_SIM_NAME = "iPhone 8";
    public static final String PREFERRED_IPAD_SIM_NAME = "iPad Air";
    public static final String[] ONLY_32BIT_DEVICES = new String[]{"iPhone 4", "iPhone 4s", "iPhone 5", "iPhone 5c", "iPad 2"};
    public static final Version ONLY_64BIT_IOS_VERSION = new Version(11, 0, 0);
    public static final Version ARM64_IOS_VERSION = new Version(14, 0, 0);
    public static final CpuArch DEFAULT_HOST_ARCH;
    private final String deviceName;
    private final String udid;
    private final String state;
    private final Version version;
    private final Set<Arch> archs;
    private final DeviceType pair;

    DeviceType(String deviceName, String udid, String state, Version version, Set<Arch> archs, DeviceType pair) {
        this.deviceName = deviceName;
        this.udid = udid;
        this.state = state;
        this.version = version;
        this.archs = archs;
        this.pair = pair;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public Version getVersion() {
        return this.version;
    }

    public Set<Arch> getArchs() {
        return Collections.unmodifiableSet(this.archs);
    }

    public DeviceType getPair() {
        return this.pair;
    }

    public String getSimpleDeviceTypeId() {
        return this.getSimpleDeviceName() + ", " + this.getVersion();
    }

    public String getSimpleDeviceName() {
        return this.deviceName + " (" + this.udid + ")";
    }

    public DeviceFamily getFamily() {
        if (this.deviceName.contains("iPhone")) {
            return DeviceFamily.iPhone;
        }
        return DeviceFamily.iPad;
    }

    public String getUdid() {
        return this.udid;
    }

    public String getState() {
        return this.state;
    }

    public DeviceType refresh() {
        for (DeviceType t : DeviceType.listDeviceTypes()) {
            if (!this.udid.equals(t.udid)) continue;
            return t;
        }
        return null;
    }

    public static List<DeviceType> listDeviceTypes() {
        try {
            String capture = new Executor(Logger.NULL_LOGGER, "xcrun").args("simctl", "list", "devices", "pairs", "-j").execCapture();
            ArrayList<DeviceType> types = new ArrayList<DeviceType>();
            JSONParser parser = new JSONParser();
            JSONObject root = (JSONObject)parser.parse(capture);
            HashMap<String, DeviceType> pairs = new HashMap<String, DeviceType>();
            JSONObject pairList = (JSONObject)root.get((Object)"pairs");
            if (pairList != null) {
                for (Object e : pairList.values()) {
                    JSONObject entry = (JSONObject)e;
                    if (entry.containsKey((Object)"state") && entry.get((Object)"state").toString().contains("unavailable")) continue;
                    JSONObject watchEntry = (JSONObject)entry.get((Object)"watch");
                    JSONObject phoneEntry = (JSONObject)entry.get((Object)"phone");
                    if (watchEntry == null || phoneEntry == null) continue;
                    String phoneUdid = phoneEntry.get((Object)"udid").toString();
                    String watchUdid = watchEntry.get((Object)"udid").toString();
                    String watchName = watchEntry.get((Object)"name").toString();
                    String watchState = watchEntry.get((Object)"state").toString();
                    if (watchState.contains("unavailable")) continue;
                    DeviceType simpleWatch = new DeviceType(watchName, watchUdid, watchState, new Version(0, 0, 0), Collections.emptySet(), null);
                    pairs.put(phoneUdid, simpleWatch);
                }
            }
            JSONObject deviceList = (JSONObject)root.get((Object)"devices");
            for (Object value : deviceList.entrySet()) {
                Map.Entry entry = (Map.Entry)value;
                String versionKey = entry.getKey().toString();
                if (versionKey.startsWith(IOS_VERSION_PREFIX)) {
                    versionKey = versionKey.replace(IOS_VERSION_PREFIX, "").replace('-', '.');
                } else {
                    if (!versionKey.startsWith("iOS ")) continue;
                    versionKey = versionKey.replace("iOS ", "");
                }
                JSONArray devices = (JSONArray)entry.getValue();
                for (Object obj : devices) {
                    JSONObject device = (JSONObject)obj;
                    boolean isAvailable = false;
                    if (device.containsKey((Object)"isAvailable")) {
                        Object o = device.get((Object)"isAvailable");
                        isAvailable = o instanceof Boolean ? ((Boolean)o).booleanValue() : "true".equals(o.toString());
                    } else if (device.containsKey((Object)"availability")) {
                        boolean bl = isAvailable = !device.get((Object)"availability").toString().contains("unavailable");
                    }
                    if (!isAvailable) continue;
                    String deviceName = device.get((Object)"name").toString();
                    Version version = Version.parse(versionKey);
                    HashSet<Arch> archs = new HashSet<Arch>();
                    if (!Arrays.asList(ONLY_32BIT_DEVICES).contains(deviceName)) {
                        if (DEFAULT_HOST_ARCH == CpuArch.arm64 && version.isSameOrBetter(ARM64_IOS_VERSION)) {
                            archs.add(new Arch(CpuArch.arm64, Environment.Simulator));
                        }
                        archs.add(new Arch(CpuArch.x86_64, Environment.Simulator));
                    }
                    String udid = device.get((Object)"udid").toString();
                    DeviceType watchPair = (DeviceType)pairs.get(udid);
                    types.add(new DeviceType(deviceName, udid, device.get((Object)"state").toString(), version, archs, watchPair));
                }
            }
            Collections.sort(types);
            return types;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int compareTo(DeviceType that) {
        int c = this.version.compareTo(that.version);
        if (c == 0 && (c = this.getFamily().compareTo(that.getFamily())) == 0) {
            c = this.deviceName.compareToIgnoreCase(that.deviceName);
        }
        return c;
    }

    private static List<DeviceType> filter(List<DeviceType> deviceTypes, Arch arch, DeviceFamily family, String deviceName, Version simVersion) {
        deviceName = deviceName == null ? null : deviceName.toLowerCase();
        ArrayList<DeviceType> result = new ArrayList<DeviceType>();
        for (DeviceType type : deviceTypes) {
            if (arch != null && !type.getArchs().contains(arch) || family != null && family != type.getFamily() || deviceName != null && !type.getDeviceName().toLowerCase().contains(deviceName) || simVersion != null && !type.version.isSameOrBetter(simVersion)) continue;
            result.add(type);
        }
        return result;
    }

    public static List<String> getSimpleDeviceTypeIds() {
        ArrayList<String> result = new ArrayList<String>();
        for (DeviceType type : DeviceType.listDeviceTypes()) {
            result.add(type.getSimpleDeviceTypeId());
        }
        return result;
    }

    public static DeviceType getDeviceType(String displayName) {
        List<DeviceType> types = DeviceType.listDeviceTypes();
        if (displayName == null) {
            return null;
        }
        for (DeviceType type : types) {
            if (!displayName.equals(type.getSimpleDeviceTypeId())) continue;
            return type;
        }
        return null;
    }

    public static DeviceType getBestDeviceType() {
        return DeviceType.getBestDeviceType(null, null, null, null);
    }

    public static DeviceType getBestDeviceType(DeviceFamily family) {
        return DeviceType.getBestDeviceType(null, family, null, null);
    }

    public static DeviceType getBestDeviceType(Arch arch, DeviceFamily family, String deviceName, String deviceVersion) {
        if (deviceName == null && family == null) {
            family = DeviceFamily.iPhone;
        }
        String preferredDeviceName = PREFERRED_IPHONE_SIM_NAME;
        if (family == DeviceFamily.iPad) {
            preferredDeviceName = PREFERRED_IPAD_SIM_NAME;
        }
        DeviceType exact = null;
        DeviceType bestDefault = null;
        DeviceType bestAny = null;
        Version version = deviceVersion != null ? Version.parse(deviceVersion) : null;
        List<DeviceType> devices = DeviceType.filter(DeviceType.listDeviceTypes(), arch, family, deviceName, version);
        for (DeviceType type : devices) {
            if (type.getDeviceName().equals(deviceName)) {
                if (exact != null && (version != null || type.version.versionCode <= exact.version.versionCode)) continue;
                exact = type;
                continue;
            }
            if (deviceName == null && type.getDeviceName().equals(preferredDeviceName)) {
                if (bestDefault != null && (version != null || type.version.versionCode <= bestDefault.version.versionCode)) continue;
                bestDefault = type;
                continue;
            }
            if (bestAny != null && (version != null || type.version.versionCode <= bestAny.version.versionCode)) continue;
            bestAny = type;
        }
        DeviceType best = exact;
        if (best == null) {
            DeviceType deviceType = best = bestDefault != null ? bestDefault : bestAny;
        }
        if (best == null) {
            throw new IllegalArgumentException("Unable to find a matching device [arch=" + arch + ", family=" + family + ", name=" + deviceName + ", version=" + version + "]");
        }
        return best;
    }

    public String toString() {
        return "DeviceType [deviceName=" + this.deviceName + ", version=" + this.version + ", archs=" + this.archs + "]";
    }

    static {
        String archProp = System.getProperty("os.arch").toLowerCase();
        DEFAULT_HOST_ARCH = archProp.matches("aarch64|arm64") ? CpuArch.arm64 : CpuArch.x86_64;
    }

    public static class Version {
        public final int major;
        public final int minor;
        public final int revision;
        public final int versionCode;

        public Version(int major, int minor, int revision) {
            this.major = major;
            this.minor = minor;
            this.revision = revision;
            this.versionCode = major << 16 | minor << 8 | revision;
        }

        static Version parse(String v) {
            String[] parts = StringUtils.split((String)v, (String)".");
            int major = Integer.parseInt(parts[0]);
            int minor = parts.length >= 2 ? Integer.parseInt(parts[1]) : 0;
            int revision = parts.length >= 3 ? Integer.parseInt(parts[2]) : 0;
            return new Version(major, minor, revision);
        }

        public String toString() {
            return this.major + "." + this.minor + (String)(this.revision != 0 ? "." + this.revision : "");
        }

        public int compareTo(Version other) {
            return this.versionCode - other.versionCode;
        }

        public boolean isSameOrBetter(Version other) {
            return this.versionCode >= other.versionCode;
        }
    }

    public static enum DeviceFamily {
        iPhone,
        iPad;

    }
}

