/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.plugin.objc;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.robovm.compiler.Linker;
import org.robovm.compiler.clazz.Clazz;
import org.robovm.compiler.config.Config;
import org.robovm.compiler.config.Resource;
import org.robovm.compiler.log.Logger;
import org.robovm.compiler.plugin.AbstractCompilerPlugin;

public class InterfaceBuilderClassesPlugin
extends AbstractCompilerPlugin {
    private static final String[] JAR_ZIP_EXTENSIONS = new String[]{"jar", "zip"};
    private static final String CLASS_EXTENSION = "class";
    private static final String CUSTOM_CLASS = "Lorg/robovm/objc/annotation/CustomClass;";
    private static final String NATIVE_CLASS = "Lorg/robovm/objc/annotation/NativeClass;";
    private static final Pattern IB_CLASS_PATTERN = Pattern.compile(".*(ViewController|View)");
    private static final Pattern EXCLUDED_PACKAGES = Pattern.compile("org\\.robovm\\.apple\\..*");
    private static final String RUNTIME_DATA_ID = "org.robovm.apple.uikit.UIApplication.preloadClasses";
    private Logger logger;
    private List<String> preloadClasses;

    @Override
    public void beforeConfig(Config.Builder builder, Config config) throws IOException {
        Object objCName;
        this.logger = config.getLogger();
        this.preloadClasses = new ArrayList<String>();
        List<String> customClasses = this.findCustomClassesInIBFiles(config);
        if (customClasses.isEmpty()) {
            return;
        }
        ArrayList<File> classpath = new ArrayList<File>();
        classpath.addAll(config.getBootclasspath());
        classpath.addAll(config.getClasspath());
        Map<String, URL> classToUrlMap = this.buildClassToUrlMap(classpath);
        HashMap<String, String> autoNameToJavaName = new HashMap<String, String>();
        for (String javaName : classToUrlMap.keySet()) {
            autoNameToJavaName.put(this.getAutoName(javaName), javaName);
        }
        HashMap<Object, String> result = new HashMap<Object, String>();
        LinkedList<String> unresolved = new LinkedList<String>(customClasses);
        HashMap<URL, String> customClassValuesCache = new HashMap<URL, String>();
        Iterator it = unresolved.iterator();
        while (it.hasNext()) {
            objCName = (String)it.next();
            String string = (String)autoNameToJavaName.get(objCName);
            if (string == null) continue;
            result.put(objCName, string);
            it.remove();
        }
        it = unresolved.iterator();
        block2: while (it.hasNext()) {
            objCName = (String)it.next();
            for (String javaName : classToUrlMap.keySet()) {
                if (!this.matchSimpleName((String)objCName, javaName)) continue;
                URL url = classToUrlMap.get(javaName);
                if (((String)objCName).equals(this.getCustomClass(url, customClassValuesCache))) {
                    result.put(objCName, javaName);
                    it.remove();
                    continue block2;
                }
                if (!this.isNativeClass(url)) continue;
                it.remove();
                continue block2;
            }
        }
        if (!unresolved.isEmpty()) {
            HashMap<String, String> candidates = new HashMap<String, String>();
            for (String string : classToUrlMap.keySet()) {
                String s;
                if (!this.looksLikeObjCClass(string) || (s = this.getCustomClass(classToUrlMap.get(string), customClassValuesCache)) == null) continue;
                candidates.put(s, string);
            }
            Iterator it2 = unresolved.iterator();
            while (it2.hasNext()) {
                String javaName;
                String string = (String)it2.next();
                javaName = (String)candidates.get(string);
                if (javaName == null) continue;
                result.put(string, javaName);
                it2.remove();
            }
        }
        if (!unresolved.isEmpty()) {
            it = unresolved.iterator();
            block6: while (it.hasNext()) {
                objCName = (String)it.next();
                for (String javaName : classToUrlMap.keySet()) {
                    String s = this.getCustomClass(classToUrlMap.get(javaName), customClassValuesCache);
                    if (!((String)objCName).equals(s)) continue;
                    result.put(objCName, javaName);
                    it.remove();
                    continue block6;
                }
            }
        }
        if (!unresolved.isEmpty()) {
            this.logger.warn("Failed to find Java classes for the following Objective-C classes in Storyboard/XIB files: %s", unresolved);
        }
        for (Map.Entry entry : result.entrySet()) {
            builder.addForceLinkClass((String)entry.getValue());
            this.preloadClasses.add((String)entry.getValue());
        }
    }

    @Override
    public void beforeLinker(Config config, Linker linker, Set<Clazz> classes) throws IOException {
        if (!this.preloadClasses.isEmpty()) {
            linker.addRuntimeData(RUNTIME_DATA_ID, StringUtils.join(this.preloadClasses, (String)",").getBytes("UTF8"));
        }
    }

    private boolean looksLikeObjCClass(String javaName) {
        return IB_CLASS_PATTERN.matcher(javaName).matches();
    }

    private boolean matchSimpleName(String objCName, String javaName) {
        if (objCName.equals(javaName)) {
            return true;
        }
        if (javaName.length() > objCName.length() && javaName.endsWith(objCName)) {
            char c = javaName.charAt(javaName.length() - objCName.length() - 1);
            return c == '.' || c == '$';
        }
        return false;
    }

    private String getCustomClass(URL url, Map<URL, String> customClassValuesCache) throws IOException {
        if (customClassValuesCache.containsKey(url)) {
            return customClassValuesCache.get(url);
        }
        class Visitor
        extends ClassVisitor {
            String customClass;

            Visitor() {
                super(262144);
            }

            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                if (InterfaceBuilderClassesPlugin.CUSTOM_CLASS.equals(desc)) {
                    return new AnnotationVisitor(262144){

                        public void visit(String name, Object value) {
                            customClass = (String)value;
                        }
                    };
                }
                return super.visitAnnotation(desc, visible);
            }
        }
        Visitor visitor = new Visitor();
        new ClassReader(IOUtils.toByteArray((InputStream)url.openStream())).accept((ClassVisitor)visitor, 0);
        customClassValuesCache.put(url, visitor.customClass);
        return visitor.customClass;
    }

    private boolean isNativeClass(URL url) throws IOException {
        class Visitor
        extends ClassVisitor {
            private boolean nativeClass;

            Visitor() {
                super(262144);
            }

            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                if (InterfaceBuilderClassesPlugin.NATIVE_CLASS.equals(desc)) {
                    this.nativeClass = true;
                }
                return super.visitAnnotation(desc, visible);
            }
        }
        Visitor visitor = new Visitor();
        new ClassReader(IOUtils.toByteArray((InputStream)url.openStream())).accept((ClassVisitor)visitor, 0);
        return visitor.nativeClass;
    }

    private String getAutoName(String javaName) {
        return "j_" + javaName.replace('.', '_');
    }

    private boolean isJarFile(File f) {
        return f.isFile() && FilenameUtils.isExtension((String)f.getName(), (String[])JAR_ZIP_EXTENSIONS);
    }

    private Map<String, URL> buildClassToUrlMap(List<File> paths) {
        Collections.reverse(paths);
        HashMap<String, URL> classToUrlMap = new HashMap<String, URL>();
        for (File path : paths) {
            if (this.isJarFile(path)) {
                try (ZipFile zipFile = new ZipFile(path);){
                    for (ZipEntry zipEntry : Collections.list(zipFile.entries())) {
                        if (zipEntry.isDirectory() || !FilenameUtils.isExtension((String)zipEntry.getName(), (String)CLASS_EXTENSION)) continue;
                        String className = FilenameUtils.removeExtension((String)zipEntry.getName()).replace('/', '.');
                        URL url = new URL("jar", null, -1, path.toURI().toString() + "!/" + zipEntry.getName());
                        classToUrlMap.put(className, url);
                    }
                }
                catch (IOException e) {
                    this.logger.warn("Failed to read JAR/ZIP file %s: %s", path.getAbsolutePath(), e.getMessage());
                }
                continue;
            }
            if (!path.isDirectory()) continue;
            path = path.getAbsoluteFile();
            for (File f : FileUtils.listFiles((File)path, (IOFileFilter)new SuffixFileFilter(".class"), (IOFileFilter)new PackageNameFilter(path.getAbsolutePath()))) {
                String string3 = FilenameUtils.removeExtension((String)f.getAbsolutePath());
                string3 = string3.substring(path.getAbsolutePath().length() + 1);
                string3 = string3.replace(File.separatorChar, '.');
                try {
                    classToUrlMap.put(string3, f.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw new Error(e);
                }
            }
        }
        return classToUrlMap;
    }

    private List<String> findCustomClassesInIBFiles(final Config config) throws IOException {
        final ArrayList<String> customClasses = new ArrayList<String>();
        for (Resource res : config.getResources()) {
            res.walk(new Resource.Walker(){

                @Override
                public boolean processDir(Resource resource, File dir, File destDir) throws IOException {
                    return true;
                }

                @Override
                public void processFile(Resource resource, File file, File destDir) throws IOException {
                    String filename = file.getName().toLowerCase();
                    if (filename.endsWith(".storyboard") || filename.endsWith(".xib")) {
                        try {
                            customClasses.addAll(InterfaceBuilderClassesPlugin.this.findCustomClassesInIBFile(file));
                        }
                        catch (IOException | XMLStreamException e) {
                            config.getLogger().warn("Failed to read Interface Builder file %s: %s", file.getAbsolutePath(), e.getMessage());
                        }
                    }
                }
            });
        }
        return customClasses;
    }

    private List<String> findCustomClassesInIBFile(File file) throws XMLStreamException, IOException {
        ArrayList<String> customClasses = new ArrayList<String>();
        try (FileInputStream fis = FileUtils.openInputStream((File)file);){
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader reader = factory.createXMLStreamReader(fis);
            while (reader.hasNext()) {
                int event = reader.next();
                switch (event) {
                    case 1: {
                        String customClass = reader.getAttributeValue(null, "customClass");
                        if (customClass == null || customClass.trim().isEmpty()) break;
                        customClasses.add(customClass);
                    }
                }
            }
            reader.close();
        }
        return customClasses;
    }

    private static class PackageNameFilter
    implements IOFileFilter {
        private final String baseDir;

        public PackageNameFilter(String baseDir) {
            this.baseDir = baseDir;
        }

        public boolean accept(File file) {
            String packag = file.getAbsolutePath().substring(this.baseDir.length() + 1).replace(File.separatorChar, '.');
            return !EXCLUDED_PACKAGES.matcher(packag).matches();
        }

        public boolean accept(File dir, String name) {
            return true;
        }
    }
}

