/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.plugin.lambda;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.robovm.compiler.CompilerException;
import org.robovm.compiler.ModuleBuilder;
import org.robovm.compiler.Types;
import org.robovm.compiler.clazz.Clazz;
import org.robovm.compiler.config.Config;
import org.robovm.compiler.plugin.AbstractCompilerPlugin;
import org.robovm.compiler.plugin.lambda.LambdaClass;
import org.robovm.compiler.plugin.lambda.LambdaClassGenerator;
import soot.Body;
import soot.Local;
import soot.PatchingChain;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.SootMethodHandle;
import soot.SootMethodRef;
import soot.SootMethodType;
import soot.SootResolver;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.ClassConstant;
import soot.jimple.Constant;
import soot.jimple.ConstantSwitch;
import soot.jimple.DefinitionStmt;
import soot.jimple.DynamicInvokeExpr;
import soot.jimple.IntConstant;
import soot.jimple.Jimple;
import soot.jimple.NullConstant;
import soot.tagkit.LineNumberTag;
import soot.tagkit.Tag;
import soot.util.Switch;

public class LambdaPlugin
extends AbstractCompilerPlugin {
    static final int BRIDGE = 64;
    static final int SYNTHETIC = 4096;
    private static int FLAG_MARKERS = 2;
    private static int FLAG_BRIDGES = 4;
    final Map<SootClass, LambdaClassGenerator> generators = new HashMap<SootClass, LambdaClassGenerator>();

    private static boolean isLambdaBootstrapMethod(SootMethodRef methodRef) {
        return methodRef.declaringClass().getName().equals("java.lang.invoke.LambdaMetafactory") && (methodRef.name().equals("metafactory") || methodRef.name().equals("altMetafactory"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterClass(Config config, Clazz clazz, ModuleBuilder moduleBuilder) throws IOException {
        Map<SootClass, LambdaClassGenerator> map = this.generators;
        synchronized (map) {
            this.generators.remove(clazz.getSootClass());
        }
    }

    @Override
    public void beforeClass(Config config, Clazz clazz, ModuleBuilder moduleBuilder) throws IOException {
        SootClass sootClass = clazz.getSootClass();
        for (SootMethod method : sootClass.getMethods()) {
            this.transformMethod(config, clazz, sootClass, method, moduleBuilder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transformMethod(Config config, Clazz clazz, SootClass sootClass, SootMethod method, ModuleBuilder moduleBuilder) throws IOException {
        if (!method.isConcrete()) {
            return;
        }
        int tmpCounter = 0;
        Body body = method.retrieveActiveBody();
        PatchingChain units = body.getUnits();
        Unit unit = units.getFirst();
        while (unit != null) {
            DynamicInvokeExpr expr;
            if (unit instanceof DefinitionStmt && ((DefinitionStmt)unit).getRightOp() instanceof DynamicInvokeExpr && LambdaPlugin.isLambdaBootstrapMethod((expr = (DynamicInvokeExpr)((DefinitionStmt)unit).getRightOp()).getBootstrapMethodRef())) {
                LambdaClassGenerator generator = null;
                Map<SootClass, LambdaClassGenerator> map = this.generators;
                synchronized (map) {
                    generator = this.generators.get(sootClass);
                    if (generator == null) {
                        generator = new LambdaClassGenerator();
                        this.generators.put(sootClass, generator);
                    }
                }
                List bsmArgs = expr.getBootstrapArgs();
                SootClass caller = sootClass;
                String invokedName = expr.getMethodRef().name();
                SootMethodRef invokedType = expr.getMethodRef();
                SootMethodType samMethodType = (SootMethodType)bsmArgs.get(0);
                SootMethodHandle implMethod = (SootMethodHandle)bsmArgs.get(1);
                SootMethodType instantiatedMethodType = (SootMethodType)bsmArgs.get(2);
                try {
                    LambdaClass callSite = null;
                    ArrayList<Type> markerInterfaces = new ArrayList<Type>();
                    ArrayList<SootMethodType> bridgeMethods = new ArrayList<SootMethodType>();
                    if (expr.getBootstrapMethodRef().name().equals("altMetafactory")) {
                        int i;
                        int count;
                        int flags = ((IntConstant)bsmArgs.get((int)3)).value;
                        int bsmArgsIdx = 4;
                        if ((flags & FLAG_MARKERS) > 0) {
                            count = ((IntConstant)bsmArgs.get((int)bsmArgsIdx++)).value;
                            for (i = 0; i < count; ++i) {
                                Object value;
                                if ((value = bsmArgs.get(bsmArgsIdx++)) instanceof Type) {
                                    markerInterfaces.add((Type)value);
                                    continue;
                                }
                                if (!(value instanceof ClassConstant)) continue;
                                String className = ((ClassConstant)value).getValue().replace('/', '.');
                                markerInterfaces.add((Type)SootResolver.v().resolveClass(className, 1).getType());
                            }
                        }
                        if ((flags & FLAG_BRIDGES) > 0) {
                            count = ((IntConstant)bsmArgs.get((int)bsmArgsIdx++)).value;
                            for (i = 0; i < count; ++i) {
                                bridgeMethods.add((SootMethodType)bsmArgs.get(bsmArgsIdx++));
                            }
                        }
                    }
                    if (bridgeMethods.size() == 0) {
                        SootClass targetType = SootResolver.v().resolveClass(invokedType.returnType().toString().replace('/', '.'), 2);
                        String samDescriptor = Types.getDescriptor(samMethodType.getParameterTypes(), samMethodType.getReturnType());
                        for (SootMethod targetTypeMethod : targetType.getMethods()) {
                            String targetTypeMethodDesc;
                            boolean isBridgeMethod = targetTypeMethod.getName().equals(invokedName);
                            isBridgeMethod &= targetTypeMethod.getParameterCount() == samMethodType.getParameterTypes().size();
                            isBridgeMethod &= (targetTypeMethod.getModifiers() & 0x40) != 0;
                            if (!(isBridgeMethod &= (targetTypeMethod.getModifiers() & 0x1000) != 0) || (targetTypeMethodDesc = Types.getDescriptor(targetTypeMethod)).equals(samDescriptor)) continue;
                            bridgeMethods.add(new BridgeMethodType(targetTypeMethod.getReturnType(), targetTypeMethod.getParameterTypes()));
                        }
                    }
                    callSite = generator.generate(caller, invokedName, invokedType, samMethodType, implMethod, instantiatedMethodType, markerInterfaces, bridgeMethods);
                    File f = clazz.getPath().getGeneratedClassFile(callSite.getLambdaClassName());
                    FileUtils.writeByteArrayToFile((File)f, (byte[])callSite.getClassData());
                    f.setLastModified(clazz.lastModified());
                    SootClass lambdaClass = SootResolver.v().makeClassRef(callSite.getLambdaClassName().replace('/', '.'));
                    Local l = (Local)((DefinitionStmt)unit).getLeftOp();
                    Type samType = callSite.getTargetMethodReturnType();
                    LinkedList<Object> newUnits = new LinkedList<Object>();
                    if (callSite.getTargetMethodName().equals("<init>")) {
                        String fieldName = lambdaClass.getName().substring(lambdaClass.getName().lastIndexOf(46) + 1);
                        SootField field = new SootField(fieldName, (Type)lambdaClass.getType(), 4234);
                        method.getDeclaringClass().addField(field);
                        newUnits.add(Jimple.v().newAssignStmt((Value)l, (Value)Jimple.v().newStaticFieldRef(field.makeRef())));
                        newUnits.add(Jimple.v().newIfStmt((Value)Jimple.v().newNeExpr((Value)l, (Value)NullConstant.v()), units.getSuccOf(unit)));
                        Local tmp = Jimple.v().newLocal("$tmp" + tmpCounter++, (Type)lambdaClass.getType());
                        body.getLocals().add((Object)tmp);
                        newUnits.add(Jimple.v().newAssignStmt((Value)tmp, (Value)Jimple.v().newNewExpr(lambdaClass.getType())));
                        newUnits.add(Jimple.v().newInvokeStmt((Value)Jimple.v().newSpecialInvokeExpr(tmp, Scene.v().makeConstructorRef(lambdaClass, Collections.emptyList()))));
                        newUnits.add(Jimple.v().newAssignStmt((Value)Jimple.v().newStaticFieldRef(field.makeRef()), (Value)tmp));
                        newUnits.add(Jimple.v().newAssignStmt((Value)l, (Value)tmp));
                    } else {
                        newUnits.add(Jimple.v().newAssignStmt((Value)l, (Value)Jimple.v().newStaticInvokeExpr(Scene.v().makeMethodRef(lambdaClass, callSite.getTargetMethodName(), callSite.getTargetMethodParameters(), samType, true), expr.getArgs())));
                    }
                    for (Object o : unit.getTags()) {
                        if (!(o instanceof LineNumberTag)) continue;
                        LineNumberTag ln = (LineNumberTag)o;
                        for (Unit unit2 : newUnits) {
                            unit2.addTag((Tag)new LineNumberTag(ln.getLineNumber()));
                        }
                    }
                    units.insertAfter(newUnits, unit);
                    units.remove((Object)unit);
                    unit = (Unit)newUnits.getLast();
                }
                catch (Throwable e) {
                    throw new CompilerException(e);
                }
            }
            unit = body.getUnits().getSuccOf(unit);
        }
    }

    static class BridgeMethodType
    extends Constant
    implements SootMethodType {
        private static final long serialVersionUID = 1L;
        private final Type returnType;
        private final List<Type> parameterTypes;

        public BridgeMethodType(Type returnType, List<Type> parameterTypes) {
            this.returnType = returnType;
            this.parameterTypes = parameterTypes;
        }

        public Type getReturnType() {
            return this.returnType;
        }

        public List<Type> getParameterTypes() {
            return Collections.unmodifiableList(this.parameterTypes);
        }

        public Type getType() {
            return RefType.v((String)"java.lang.invoke.MethodType");
        }

        public void apply(Switch sw) {
            ((ConstantSwitch)sw).defaultCase((Object)this);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('(');
            Iterator<Type> it = this.parameterTypes.iterator();
            while (it.hasNext()) {
                sb.append(it.next());
                if (!it.hasNext()) continue;
                sb.append(',');
            }
            return sb.append(')').append(this.returnType).toString();
        }
    }
}

