/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.plugin.desugar;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.robovm.compiler.ModuleBuilder;
import org.robovm.compiler.clazz.Clazz;
import org.robovm.compiler.config.Config;
import org.robovm.compiler.plugin.AbstractCompilerPlugin;
import org.robovm.compiler.plugin.PluginArgument;
import org.robovm.compiler.plugin.PluginArguments;
import org.robovm.compiler.plugin.desugar.StringConcatRewriter;
import soot.Body;
import soot.PatchingChain;
import soot.SootClass;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Unit;
import soot.Value;
import soot.jimple.DefinitionStmt;
import soot.jimple.DynamicInvokeExpr;

public class StringConcatRewriterPlugin
extends AbstractCompilerPlugin {
    private StringConcatRewriter rewriter;
    private static final String ARG_KEY_ENABLE_PLUGIN = "enableJava9StringConcat";
    private Boolean enabled;

    private void init() {
        if (this.rewriter == null) {
            this.rewriter = new StringConcatRewriter();
        }
    }

    private static boolean isMakeConcatBootstrapMethod(SootMethodRef methodRef) {
        return methodRef.declaringClass().getName().equals("java.lang.invoke.StringConcatFactory") && methodRef.name().equals("makeConcat");
    }

    private static boolean isMakeConcatWithConstantsBootstrapMethod(SootMethodRef methodRef) {
        return methodRef.declaringClass().getName().equals("java.lang.invoke.StringConcatFactory") && methodRef.name().equals("makeConcatWithConstants");
    }

    @Override
    public PluginArguments getArguments() {
        ArrayList<PluginArgument> args = new ArrayList<PluginArgument>();
        args.add(new PluginArgument(ARG_KEY_ENABLE_PLUGIN, "false", "Flag: disables String concatenation by replacing dynamicInvoke instructions"));
        return new PluginArguments("desugar", args);
    }

    private boolean isEnabled(Config config) {
        if (this.enabled == null) {
            this.enabled = this.argumentValue(this.parseArguments(config), ARG_KEY_ENABLE_PLUGIN, true);
        }
        return this.enabled;
    }

    @Override
    public void beforeConfig(Config.Builder builder, Config config) throws IOException {
        super.beforeConfig(builder, config);
        this.enabled = null;
    }

    @Override
    public void beforeClass(Config config, Clazz clazz, ModuleBuilder moduleBuilder) throws IOException {
        if (this.isEnabled(config)) {
            this.init();
            SootClass sootClass = clazz.getSootClass();
            for (SootMethod method : sootClass.getMethods()) {
                this.transformStringConcats(method);
            }
        }
    }

    private void transformStringConcats(SootMethod method) {
        if (!method.isConcrete()) {
            return;
        }
        Body body = method.retrieveActiveBody();
        PatchingChain units = body.getUnits();
        Unit unit = units.getFirst();
        while (unit != null) {
            if (unit instanceof DefinitionStmt && ((DefinitionStmt)unit).getRightOp() instanceof DynamicInvokeExpr) {
                DynamicInvokeExpr expr = (DynamicInvokeExpr)((DefinitionStmt)unit).getRightOp();
                Value outValue = ((DefinitionStmt)unit).getLeftOp();
                SootMethodRef bootstrapMethodRef = expr.getBootstrapMethodRef();
                List args = expr.getArgs();
                List bootstrapArgs = expr.getBootstrapArgs();
                LinkedList<Unit> newUnits = null;
                if (StringConcatRewriterPlugin.isMakeConcatBootstrapMethod(bootstrapMethodRef)) {
                    newUnits = this.rewriter.rewriteMakeConcat(body, outValue, args);
                } else if (StringConcatRewriterPlugin.isMakeConcatWithConstantsBootstrapMethod(bootstrapMethodRef)) {
                    newUnits = this.rewriter.rewriteMakeConcatWithConstants(body, outValue, args, bootstrapArgs);
                }
                if (newUnits != null) {
                    units.insertAfter(newUnits, unit);
                    units.remove((Object)unit);
                    unit = newUnits.getLast();
                }
            }
            unit = body.getUnits().getSuccOf(unit);
        }
    }
}

