/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.plugin.debug.kotlin;

import java.util.ArrayList;
import org.robovm.compiler.config.Config;
import org.robovm.compiler.plugin.debug.DebugInformationPlugin;

public class KotlinTools {
    private static final String DEBUG_SECTION = "*S KotlinDebug";
    private static final String FILE_SECTION = "*F";
    private static final String LINE_SECTION = "*L";
    private static final String END = "*E";

    public static DebugInformationPlugin.LineNumberMapper parseSMAP(Config config, byte[] smapData, String internalName) {
        String mappingInfo = new String(smapData);
        ArrayList<Range> lineMappings = new ArrayList<Range>();
        int debugSectionStart = mappingInfo.indexOf(DEBUG_SECTION);
        if (debugSectionStart < 0) {
            return DebugInformationPlugin.LineNumberMapper.DIRECT;
        }
        mappingInfo = mappingInfo.substring(debugSectionStart + DEBUG_SECTION.length());
        int fileSectionStart = mappingInfo.indexOf(FILE_SECTION) + FILE_SECTION.length();
        int lineSectionAnchor = mappingInfo.indexOf(LINE_SECTION);
        String files = mappingInfo.substring(fileSectionStart, lineSectionAnchor);
        String[] fileEntries = files.trim().split("\\+");
        int ownFileIndex = -1;
        for (String string : fileEntries) {
            String fileInternalName = string.trim();
            if (fileInternalName.isEmpty()) continue;
            int indexEnd = fileInternalName.indexOf(32);
            int index = Integer.parseInt(fileInternalName.substring(0, indexEnd));
            int newLine = fileInternalName.indexOf(10);
            if (!(fileInternalName = fileInternalName.substring(newLine + 1).trim()).equals(internalName)) continue;
            ownFileIndex = index;
            break;
        }
        if (ownFileIndex == -1) {
            return DebugInformationPlugin.LineNumberMapper.DIRECT;
        }
        String[] lines = mappingInfo.substring(lineSectionAnchor + LINE_SECTION.length(), mappingInfo.indexOf(END)).trim().split("\\n");
        int minTargetIndex = Integer.MAX_VALUE;
        int maxTargetIndex = Integer.MIN_VALUE;
        for (String lineMapping : lines) {
            try {
                Range range = KotlinTools.parseLineMap(ownFileIndex, lineMapping);
                if (range.targetIndexStart < minTargetIndex) {
                    minTargetIndex = range.targetIndexStart;
                }
                if (range.targetIndexEnd > maxTargetIndex) {
                    maxTargetIndex = range.targetIndexEnd;
                }
                lineMappings.add(range);
            }
            catch (Throwable e) {
                if (!config.getHome().isDev()) continue;
                config.getLogger().warn(e.getLocalizedMessage(), new Object[0]);
            }
        }
        if (lineMappings.size() == 1) {
            Range range = (Range)lineMappings.get(0);
            int targetIndexStart = range.targetIndexStart;
            int targetIndexEnd = range.targetIndexEnd;
            int originalIndex = range.originalIndex;
            return l -> {
                if (l >= targetIndexStart && l <= targetIndexEnd) {
                    return originalIndex + l - targetIndexStart;
                }
                return l;
            };
        }
        if (lineMappings.size() > 1) {
            int n = minTargetIndex;
            int maxLine = maxTargetIndex;
            return l -> {
                if (l >= minLine && l <= maxLine) {
                    for (Range r : lineMappings) {
                        if (l < r.targetIndexStart || l > r.targetIndexEnd) continue;
                        return r.originalIndex + l - r.targetIndexStart;
                    }
                }
                return l;
            };
        }
        return DebugInformationPlugin.LineNumberMapper.DIRECT;
    }

    static Range parseLineMap(int expectedFileIndex, String lineMapping) {
        int range;
        int dest;
        int fileIndex;
        int fileSeparatorIdx = lineMapping.indexOf(35);
        if (fileSeparatorIdx <= 0) {
            throw new IllegalArgumentException("fileId(#) separator not found in " + lineMapping);
        }
        int semicolonIdx = lineMapping.indexOf(58, fileSeparatorIdx + 1);
        if (semicolonIdx < fileSeparatorIdx + 2) {
            throw new IllegalArgumentException("fileId(:) separator not found or empty in " + lineMapping);
        }
        int commaIdx = lineMapping.indexOf(44, fileSeparatorIdx + 1);
        if (commaIdx > 0 && commaIdx < fileSeparatorIdx + 2) {
            throw new IllegalArgumentException("range(,) separator is empty in " + lineMapping);
        }
        int originalIndex = Integer.parseInt(lineMapping.substring(0, fileSeparatorIdx));
        if (commaIdx < 0) {
            fileIndex = Integer.parseInt(lineMapping.substring(fileSeparatorIdx + 1, semicolonIdx));
            dest = Integer.parseInt(lineMapping.substring(semicolonIdx + 1));
            range = 1;
        } else if (commaIdx > semicolonIdx + 1) {
            fileIndex = Integer.parseInt(lineMapping.substring(fileSeparatorIdx + 1, semicolonIdx));
            dest = Integer.parseInt(lineMapping.substring(semicolonIdx + 1, commaIdx));
            range = Integer.parseInt(lineMapping.substring(commaIdx + 1));
        } else if (semicolonIdx > commaIdx + 1) {
            fileIndex = Integer.parseInt(lineMapping.substring(fileSeparatorIdx + 1, commaIdx));
            dest = Integer.parseInt(lineMapping.substring(semicolonIdx + 1));
            range = Integer.parseInt(lineMapping.substring(commaIdx + 1, semicolonIdx));
        } else {
            throw new IllegalArgumentException("Empty range/dest in " + lineMapping);
        }
        if (fileIndex != expectedFileIndex) {
            throw new IllegalArgumentException("fileIndex doesn't match expected " + expectedFileIndex + " in " + lineMapping);
        }
        return new Range(originalIndex, dest, dest + range - 1);
    }

    static class Range {
        final int originalIndex;
        final int targetIndexStart;
        final int targetIndexEnd;

        Range(int originalIndex, int targetIndexStart, int targetIndexEnd) {
            this.originalIndex = originalIndex;
            this.targetIndexStart = targetIndexStart;
            this.targetIndexEnd = targetIndexEnd;
        }
    }
}

