/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.plugin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import org.robovm.compiler.Linker;
import org.robovm.compiler.clazz.Clazz;
import org.robovm.compiler.config.Config;
import org.robovm.compiler.plugin.AbstractCompilerPlugin;
import org.robovm.compiler.plugin.PluginArgument;
import org.robovm.compiler.plugin.PluginArguments;
import org.robovm.llvm.ObjectFile;

public class BuildGarbageCollectorPlugin
extends AbstractCompilerPlugin {
    private static final String ARG_KEY_ENABLE_PLUGIN = "enable";
    private Boolean enabled;

    @Override
    public PluginArguments getArguments() {
        ArrayList<PluginArgument> args = new ArrayList<PluginArgument>();
        args.add(new PluginArgument(ARG_KEY_ENABLE_PLUGIN, "false", "Flag: disables releasing compilation caches as soon as not needed"));
        return new PluginArguments("buildGC", args);
    }

    private boolean isEnabled(Config config) {
        if (this.enabled == null) {
            this.enabled = this.argumentValue(this.parseArguments(config), ARG_KEY_ENABLE_PLUGIN, true);
        }
        return this.enabled;
    }

    @Override
    public void afterClassDependenciesResolved(Config config, Clazz clazz) {
        if (this.isEnabled(config)) {
            clazz.getClazzInfo().dropDependencyData();
        }
    }

    @Override
    public void afterObjectFile(Config config, Clazz clazz, File objectFile, ObjectFile objectFileData) throws IOException {
        if (this.isEnabled(config)) {
            clazz.shrinkSoot();
        }
    }

    @Override
    public void beforeLinker(Config config, Linker linker, Set<Clazz> classes) {
        if (this.isEnabled(config)) {
            config.getClazzes().disposeSoot();
        }
    }

    @Override
    public void afterLinker(Config config, File executable) throws IOException {
        if (this.isEnabled(config)) {
            config.disposeBuildData();
        }
    }
}

