/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm.debug.dwarf;

import org.robovm.compiler.ModuleBuilder;
import org.robovm.compiler.llvm.FunctionRef;
import org.robovm.compiler.llvm.MetadataNode;
import org.robovm.compiler.llvm.MetadataNodeBuilder;
import org.robovm.compiler.llvm.debug.dwarf.DIBaseItem;
import org.robovm.compiler.llvm.debug.dwarf.DICompositeType;
import org.robovm.compiler.llvm.debug.dwarf.DIHeader;
import org.robovm.compiler.llvm.debug.dwarf.DILocalVariable;
import org.robovm.compiler.llvm.debug.dwarf.DIMutableItemList;

public class DISubprogram
extends DIBaseItem {
    private String signature;
    private int defLineNo;
    private int scopeLineNo;
    private int flags;
    private boolean isStatic;
    private DIBaseItem file;
    private DIBaseItem fileContext;
    private DICompositeType subrotineType;
    private FunctionRef llvmFunction;
    private DIMutableItemList<DILocalVariable> variables;

    public DISubprogram(ModuleBuilder builder) {
        super(builder);
    }

    private MetadataNode build() {
        MetadataNodeBuilder builder = new MetadataNodeBuilder();
        builder.add(new DIHeader().add(46).add(this.signature).add(this.signature).add("").add(this.defLineNo).add(this.isStatic).add(true).add(0).add(0).add(this.flags).add(false).add(this.scopeLineNo));
        builder.add(this.file.get());
        builder.add(this.fileContext.get());
        builder.add(this.subrotineType.get());
        builder.add(null);
        builder.add(this.llvmFunction);
        builder.add(null);
        builder.add(null);
        builder.add(this.variables != null ? this.variables.get() : null);
        return builder.build();
    }

    public String toString() {
        return this.build().toString();
    }

    public DISubprogram setSignature(String signature) {
        this.signature = signature;
        return this;
    }

    public DISubprogram setDefLineNo(int defLineNo) {
        this.defLineNo = defLineNo;
        return this;
    }

    public DISubprogram setScopeLineNo(int scopeLineNo) {
        this.scopeLineNo = scopeLineNo;
        return this;
    }

    public DISubprogram setFlags(int flags) {
        this.flags = flags;
        return this;
    }

    public DISubprogram setStatic(boolean aStatic) {
        this.isStatic = aStatic;
        return this;
    }

    public DISubprogram setFile(DIBaseItem file) {
        this.file = file;
        return this;
    }

    public DISubprogram setFileContext(DIBaseItem fileContext) {
        this.fileContext = fileContext;
        return this;
    }

    public DISubprogram setSubrotineType(DICompositeType subrotineType) {
        this.subrotineType = subrotineType;
        return this;
    }

    public void setLlvmFunction(FunctionRef llvmFunction) {
        this.llvmFunction = llvmFunction;
    }

    public void setVariables(DIMutableItemList<DILocalVariable> variables) {
        this.variables = variables;
    }
}

