/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm.debug.dwarf;

import java.io.IOException;
import java.io.Writer;
import org.robovm.compiler.ModuleBuilder;
import org.robovm.compiler.llvm.BooleanConstant;
import org.robovm.compiler.llvm.IntegerConstant;
import org.robovm.compiler.llvm.Metadata;
import org.robovm.compiler.llvm.MetadataString;
import org.robovm.compiler.llvm.NamedMetadata;
import org.robovm.compiler.llvm.UnnamedMetadata;

public class DIBaseItem {
    private final Metadata value;

    public DIBaseItem() {
        this.value = new MetadataWrap();
    }

    protected DIBaseItem(Metadata w) {
        this.value = w != null ? w : new MetadataWrap();
    }

    public DIBaseItem(ModuleBuilder builder) {
        this(builder, (Metadata)null);
    }

    protected DIBaseItem(ModuleBuilder builder, Metadata w) {
        this.value = builder.newUnnamedMetadata(w != null ? w : new MetadataWrap()).ref();
    }

    public DIBaseItem(ModuleBuilder builder, String name) {
        this(builder, name, null);
    }

    protected DIBaseItem(ModuleBuilder builder, String name, Metadata ... values) {
        NamedMetadata namedMetadata;
        if (values == null) {
            namedMetadata = new NamedMetadata(name, builder.newUnnamedMetadata(new MetadataWrap()));
        } else {
            UnnamedMetadata[] unnamedMetadataList = new UnnamedMetadata[values.length];
            int idx = 0;
            for (Metadata v : values) {
                unnamedMetadataList[idx++] = builder.newUnnamedMetadata(v);
            }
            namedMetadata = new NamedMetadata(name, unnamedMetadataList);
        }
        builder.addNamedMetadata(namedMetadata);
        this.value = new NamedMetadataRef(name);
    }

    public final Metadata get() {
        return this.value;
    }

    protected IntegerConstant v(int i) {
        return new IntegerConstant(i);
    }

    protected MetadataString v(String s) {
        return new MetadataString(s);
    }

    protected BooleanConstant v(boolean b) {
        return b ? BooleanConstant.TRUE : BooleanConstant.FALSE;
    }

    private class MetadataWrap
    extends Metadata {
        private MetadataWrap() {
        }

        public String toString() {
            return DIBaseItem.this.toString();
        }

        @Override
        public void write(Writer writer) throws IOException {
            writer.write(this.toString());
        }
    }

    private static class NamedMetadataRef
    extends Metadata {
        private final String name;

        NamedMetadataRef(String name) {
            this.name = name;
        }

        public String toString() {
            return "!" + this.name;
        }

        @Override
        public void write(Writer writer) throws IOException {
            writer.write(this.toString());
        }
    }
}

