/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.robovm.compiler.llvm.BasicBlockRef;
import org.robovm.compiler.llvm.Instruction;
import org.robovm.compiler.llvm.IntegerConstant;
import org.robovm.compiler.llvm.Value;
import org.robovm.compiler.llvm.VariableRef;

public class Switch
extends Instruction {
    private final Value value;
    private final BasicBlockRef def;
    private final Map<IntegerConstant, BasicBlockRef> alt;

    public Switch(Value value, BasicBlockRef def, IntegerConstant altVal, BasicBlockRef altBlock) {
        this(value, def, Collections.singletonMap(altVal, altBlock));
    }

    public Switch(Value value, BasicBlockRef def, Map<IntegerConstant, BasicBlockRef> alt) {
        if (!value.isInteger()) {
            throw new IllegalArgumentException("Integer type expected");
        }
        this.value = value;
        this.def = def;
        this.alt = alt;
    }

    @Override
    public Set<VariableRef> getReadsFrom() {
        if (this.value instanceof VariableRef) {
            return Collections.singleton((VariableRef)this.value);
        }
        return super.getReadsFrom();
    }

    @Override
    public Set<BasicBlockRef> getBranchTargets() {
        HashSet<BasicBlockRef> result = new HashSet<BasicBlockRef>();
        result.add(this.def);
        result.addAll(this.alt.values());
        return result;
    }

    @Override
    public void write(Writer writer) throws IOException {
        writer.write("switch ");
        this.value.getType().write(writer);
        writer.write(32);
        this.value.write(writer);
        writer.write(", label %");
        writer.write(this.def.getName());
        writer.write(" [ ");
        for (Map.Entry<IntegerConstant, BasicBlockRef> pair : this.alt.entrySet()) {
            pair.getKey().getType().write(writer);
            writer.write(32);
            pair.getKey().write(writer);
            writer.write(", label %");
            writer.write(pair.getValue().getName());
            writer.write(32);
        }
        writer.write(93);
    }

    public String toString() {
        return this.toString(this::write);
    }
}

