/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.robovm.compiler.llvm.Constant;
import org.robovm.compiler.llvm.StructureType;
import org.robovm.compiler.llvm.Type;
import org.robovm.compiler.llvm.Value;

public class StructureConstant
extends Constant {
    private final StructureType type;
    private final Value[] values;

    public StructureConstant(StructureType type, Value ... values) {
        this.type = type;
        this.values = values;
    }

    @Override
    public StructureType getType() {
        return this.type;
    }

    private static void flattenInto(List<Value> dest, StructureConstant struct) {
        for (Value v : struct.values) {
            if (v instanceof StructureConstant) {
                StructureConstant.flattenInto(dest, (StructureConstant)v);
                continue;
            }
            dest.add(v);
        }
    }

    public StructureConstant flatten() {
        ArrayList<Value> flattenValues = new ArrayList<Value>();
        StructureConstant.flattenInto(flattenValues, this);
        Type[] types = new Type[flattenValues.size()];
        int i = 0;
        for (Value v : flattenValues) {
            types[i++] = v.getType();
        }
        return new StructureConstant(new StructureType(types), flattenValues.toArray(new Value[0]));
    }

    @Override
    public void write(Writer writer) throws IOException {
        writer.write(123);
        for (int i = 0; i < this.values.length; ++i) {
            if (i > 0) {
                writer.write(", ");
            }
            this.values[i].getType().write(writer);
            writer.write(32);
            this.values[i].write(writer);
        }
        writer.write(125);
    }

    public String toString() {
        return this.toString(this::write);
    }
}

