/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm;

import java.io.IOException;
import java.io.Writer;
import org.robovm.compiler.llvm.ArrayType;
import org.robovm.compiler.llvm.Constant;
import org.robovm.compiler.llvm.Type;

public class StringConstant
extends Constant {
    private final ArrayType type;
    private final byte[] bytes;

    public StringConstant(byte[] bytes) {
        this.bytes = bytes;
        this.type = new ArrayType(bytes.length, Type.I8);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public void write(Writer writer) throws IOException {
        writer.write("c\"");
        StringConstant.escape(writer, this.bytes);
        writer.write(34);
    }

    public String toString() {
        return this.toString(this::write);
    }

    static void escape(Writer writer, byte[] bytes) throws IOException {
        for (int i = 0; i < bytes.length; ++i) {
            int b = bytes[i] & 0xFF;
            if (b < 32 || b > 126 || b == 34 || b == 92) {
                writer.write(String.format("\\%02X", b));
                continue;
            }
            writer.write((char)b);
        }
    }
}

