/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm;

import java.io.IOException;
import java.io.Writer;
import org.robovm.compiler.llvm.Constant;
import org.robovm.compiler.llvm.GlobalRef;
import org.robovm.compiler.llvm.Linkage;
import org.robovm.compiler.llvm.PointerType;
import org.robovm.compiler.llvm.Type;
import org.robovm.compiler.llvm.Writable;

public class Global
implements Writable {
    private final String name;
    private final Linkage linkage;
    private final Constant value;
    private final Type type;
    private final boolean constant;
    private final String section;

    public Global(String name, Type type) {
        this(name, Linkage.external, type, false);
    }

    public Global(String name, Type type, boolean constant) {
        this(name, Linkage.external, type, constant);
    }

    public Global(String name, Linkage linkage, Type type, boolean constant) {
        this.name = name;
        this.linkage = linkage;
        this.value = null;
        this.type = type;
        this.constant = constant;
        this.section = null;
    }

    public Global(String name, Constant value) {
        this(name, null, value, false, null);
    }

    public Global(String name, Constant value, boolean constant) {
        this(name, null, value, constant, null);
    }

    public Global(String name, Linkage linkage, Constant value) {
        this(name, linkage, value, false, null);
    }

    public Global(String name, Linkage linkage, Constant value, boolean constant) {
        this(name, linkage, value, constant, null);
    }

    public Global(String name, Constant value, boolean constant, String section) {
        this(name, null, value, constant, section);
    }

    public Global(String name, Linkage linkage, Constant value, boolean constant, String section) {
        this.name = name;
        this.linkage = linkage;
        this.value = value;
        this.type = value.getType();
        this.constant = constant;
        this.section = section;
    }

    public GlobalRef ref() {
        return new GlobalRef(this);
    }

    public String getName() {
        return this.name;
    }

    public PointerType getType() {
        return new PointerType(this.type);
    }

    public void writeDefinition(Writer writer) throws IOException {
        writer.write("@\"");
        writer.write(this.name);
        writer.write("\" = ");
        if (this.linkage != null) {
            writer.write(this.linkage.toString());
            writer.write(32);
        }
        if (this.constant) {
            writer.write("constant ");
        } else {
            writer.write("global ");
        }
        this.type.write(writer);
        if (this.value != null) {
            writer.write(32);
            this.value.write(writer);
        }
        if (this.section != null) {
            writer.write(", section \"");
            writer.write(this.section);
            writer.write(34);
        }
    }

    public String getDefinition() {
        return this.toString(this::writeDefinition);
    }

    @Override
    public void write(Writer writer) throws IOException {
        throw new IllegalStateException("writeDefinition to be called!");
    }

    public String toString() {
        return "@\"" + this.name + "\"";
    }
}

