/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import org.robovm.compiler.llvm.PointerType;
import org.robovm.compiler.llvm.Type;

public class FunctionType
extends PointerType {
    private final Type returnType;
    private final Type[] parameterTypes;
    private final boolean varargs;

    public FunctionType(Type returnType, Type ... parameterTypes) {
        this(returnType, false, parameterTypes);
    }

    public FunctionType(Type returnType, boolean varargs, Type ... parameterTypes) {
        super((Type)null);
        this.returnType = returnType;
        this.varargs = varargs;
        this.parameterTypes = (Type[])parameterTypes.clone();
    }

    public FunctionType(String alias, Type returnType, Type ... parameterTypes) {
        this(alias, returnType, false, parameterTypes);
    }

    public FunctionType(String alias, Type returnType, boolean varargs, Type ... parameterTypes) {
        super(alias, null);
        this.returnType = returnType;
        this.varargs = varargs;
        this.parameterTypes = (Type[])parameterTypes.clone();
    }

    @Override
    public Type getBase() {
        throw new UnsupportedOperationException("Function pointers cannot be dereferenced");
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public boolean isVarargs() {
        return this.varargs;
    }

    public Type[] getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public void writeDefinition(Writer writer) throws IOException {
        this.returnType.write(writer);
        writer.write(" (");
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            if (i > 0) {
                writer.write(", ");
            }
            this.parameterTypes[i].write(writer);
        }
        if (this.varargs) {
            if (this.parameterTypes.length > 0) {
                writer.write(", ");
            }
            writer.write("...");
        }
        writer.write(")*");
    }

    @Override
    public String getDefinition() {
        return this.toString(this::writeDefinition);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.parameterTypes);
        result = 31 * result + (this.returnType == null ? 0 : this.returnType.hashCode());
        result = 31 * result + (this.varargs ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionType other = (FunctionType)obj;
        if (!Arrays.equals(this.parameterTypes, other.parameterTypes)) {
            return false;
        }
        if (this.returnType == null ? other.returnType != null : !this.returnType.equals(other.returnType)) {
            return false;
        }
        return this.varargs == other.varargs;
    }
}

