/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm;

import java.io.IOException;
import java.io.Writer;
import org.robovm.compiler.llvm.FunctionRef;
import org.robovm.compiler.llvm.FunctionType;
import org.robovm.compiler.llvm.Type;
import org.robovm.compiler.llvm.Writable;

public class FunctionDeclaration
implements Writable {
    private final String name;
    private final FunctionType type;

    public FunctionDeclaration(String name, FunctionType type) {
        this.name = name;
        this.type = type;
    }

    public FunctionDeclaration(FunctionRef ref) {
        this(ref.getName(), ref.getType());
    }

    public String getName() {
        return this.name;
    }

    public FunctionType getType() {
        return this.type;
    }

    public FunctionRef ref() {
        return new FunctionRef(this.name, this.type);
    }

    @Override
    public void write(Writer writer) throws IOException {
        Type returnType = this.type.getReturnType();
        Type[] parameterTypes = this.type.getParameterTypes();
        writer.write("declare ");
        returnType.write(writer);
        writer.write(" @\"");
        writer.write(this.name);
        writer.write("\"(");
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (i > 0) {
                writer.write(", ");
            }
            parameterTypes[i].write(writer);
        }
        if (this.type.isVarargs()) {
            writer.write(", ...");
        }
        writer.write(41);
    }

    public String toString() {
        return this.toString(this::write);
    }
}

