/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm;

import java.io.IOException;
import java.io.Writer;
import org.robovm.compiler.llvm.BinaryOpInstruction;
import org.robovm.compiler.llvm.Value;
import org.robovm.compiler.llvm.Variable;

public abstract class FloatingPointBinaryInstruction
extends BinaryOpInstruction {
    private final String name;

    protected FloatingPointBinaryInstruction(String name, Variable result, Value op1, Value op2) {
        super(result, op1, op2);
        if (!(result.isFloatingPoint() && op1.isFloatingPoint() && op2.isFloatingPoint())) {
            throw new IllegalArgumentException("Floating point type expected");
        }
        if (!result.getType().equals(op1.getType()) || !op1.getType().equals(op2.getType())) {
            throw new IllegalArgumentException("Type mismatch ");
        }
        this.name = name;
    }

    @Override
    public void write(Writer writer) throws IOException {
        writer.append(this.result.toString()).append(" = ").append(this.name).append(' ');
        this.op1.getType().write(writer);
        writer.write(32);
        this.op1.write(writer);
        writer.write(", ");
        this.op2.write(writer);
    }

    public String toString() {
        return this.toString(this::write);
    }
}

