/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.llvm;

import org.robovm.compiler.llvm.PrimitiveType;
import org.robovm.compiler.llvm.StructureType;
import org.robovm.compiler.llvm.Type;
import org.robovm.compiler.llvm.UserType;
import org.robovm.compiler.llvm.VectorStructureType;
import org.robovm.llvm.Context;
import org.robovm.llvm.Module;
import org.robovm.llvm.Target;
import org.robovm.llvm.TargetMachine;

public class DataLayout {
    private final String triple;
    private final Target target;

    public DataLayout(String triple) {
        this.triple = triple;
        this.target = Target.lookupTarget((String)triple);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T runTypeQuery(Type type, TypeCallback<T> cb) {
        Context context = null;
        Module module = null;
        TargetMachine targetMachine = null;
        try {
            VectorStructureType st;
            Object definition = type instanceof PrimitiveType ? "{" + ((PrimitiveType)type).getName() + "}" : (type instanceof VectorStructureType ? (!(st = (VectorStructureType)type).isVectorArray() ? "{" + ((StructureType)type).getDefinition() + "}" : ((StructureType)type).getDefinition()) : (type instanceof StructureType ? ((StructureType)type).getDefinition() : "{" + ((UserType)type).getDefinition() + "}"));
            context = new Context();
            module = Module.parseIR((Context)context, (String)("%t = type " + (String)definition), null);
            targetMachine = this.target.createTargetMachine(this.triple);
            T t = cb.doWithType(targetMachine, module.getTypeByName("t"));
            return t;
        }
        finally {
            if (targetMachine != null) {
                targetMachine.dispose();
            }
            if (module != null) {
                module.dispose();
            }
            if (context != null) {
                context.dispose();
            }
        }
    }

    public int getAllocSize(Type type) {
        return this.runTypeQuery(type, new TypeCallback<Integer>(){

            @Override
            Integer doWithType(TargetMachine targetMachine, org.robovm.llvm.Type type) {
                return (int)targetMachine.getDataLayout().getTypeAllocSize(type);
            }
        });
    }

    public int getAlignment(Type type) {
        return this.runTypeQuery(type, new TypeCallback<Integer>(){

            @Override
            Integer doWithType(TargetMachine targetMachine, org.robovm.llvm.Type type) {
                return targetMachine.getDataLayout().getABITypeAlignment(type);
            }
        });
    }

    public int getStoreSize(Type type) {
        return this.runTypeQuery(type, new TypeCallback<Integer>(){

            @Override
            Integer doWithType(TargetMachine targetMachine, org.robovm.llvm.Type type) {
                return (int)targetMachine.getDataLayout().getTypeStoreSize(type);
            }
        });
    }

    public int getOffsetOfElement(StructureType type, final int idx) {
        if (type instanceof VectorStructureType) {
            if (type.getOwnMembersOffset() != 0) {
                throw new IllegalArgumentException("Failed to process Vectorized struct. Probably it inherits another struct!");
            }
            return this.getStoreSize(type.getTypeAt(0)) * idx;
        }
        return this.runTypeQuery(type, new TypeCallback<Integer>(){

            @Override
            Integer doWithType(TargetMachine targetMachine, org.robovm.llvm.Type type) {
                return (int)targetMachine.getDataLayout().getOffsetOfElement(type, idx);
            }
        });
    }

    private static abstract class TypeCallback<T> {
        private TypeCallback() {
        }

        abstract T doWithType(TargetMachine var1, org.robovm.llvm.Type var2);
    }
}

