/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.config;

import java.nio.ByteOrder;
import org.robovm.compiler.config.CpuArch;
import org.robovm.compiler.config.Environment;
import org.robovm.compiler.config.OS;

public class Arch
implements Comparable<Arch> {
    public static final Arch thumbv7 = new Arch(CpuArch.thumbv7);
    public static final Arch arm64 = new Arch(CpuArch.arm64);
    public static final Arch x86_64 = new Arch(CpuArch.x86_64);
    private final CpuArch cpuArch;
    private final Environment env;

    public Arch(CpuArch arch, Environment env) {
        this.cpuArch = arch;
        this.env = env;
    }

    public Arch(CpuArch arch) {
        this.cpuArch = arch;
        this.env = Environment.Native;
    }

    public static Arch getDefaultArch() {
        return new Arch(CpuArch.getDefaultArch());
    }

    public Arch promoteTo(OS os) {
        if (os == OS.ios && this.env == Environment.Native && this.cpuArch == CpuArch.x86_64) {
            return new Arch(this.cpuArch, Environment.Simulator);
        }
        return this;
    }

    public static Arch[] supported(OS os) {
        switch (os) {
            case linux: {
                return new Arch[]{x86_64};
            }
            case macosx: {
                return new Arch[]{x86_64, arm64};
            }
            case ios: {
                return new Arch[]{new Arch(CpuArch.x86_64, Environment.Simulator), new Arch(CpuArch.arm64, Environment.Simulator), arm64, thumbv7};
            }
        }
        throw new IllegalArgumentException("Unexpected OS");
    }

    public CpuArch getCpuArch() {
        return this.cpuArch;
    }

    public Environment getEnv() {
        return this.env;
    }

    public Arch copy(Environment anotherEnv) {
        return new Arch(this.cpuArch, anotherEnv);
    }

    public String toString() {
        return this.cpuArch + this.env.asLlvmSuffix("-");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Arch arch = (Arch)o;
        if (this.cpuArch != arch.cpuArch) {
            return false;
        }
        return this.env == arch.env;
    }

    public int hashCode() {
        int result = this.cpuArch.hashCode();
        result = 31 * result + this.env.hashCode();
        return result;
    }

    @Override
    public int compareTo(Arch o) {
        int res = this.cpuArch.compareTo(o.cpuArch);
        if (res == 0) {
            res = this.env.compareTo(o.env);
        }
        return res;
    }

    public static Arch parse(String s) {
        CpuArch cpuArch;
        String[] chunks = s.split("-");
        Environment env = Environment.Native;
        if (chunks.length == 1) {
            cpuArch = CpuArch.valueOf(chunks[0]);
        } else if (chunks.length == 2) {
            cpuArch = CpuArch.valueOf(chunks[0]);
            env = Environment.parse(chunks[1]);
        } else {
            throw new IllegalArgumentException("Unexpected Slice configuration `" + s + "`");
        }
        return new Arch(cpuArch, env);
    }

    public boolean is32Bit() {
        return this.cpuArch.is32Bit();
    }

    public ByteOrder getByteOrder() {
        return this.cpuArch.getByteOrder();
    }

    public boolean isArm() {
        return this.cpuArch.isArm();
    }

    public String getLlvmCpu() {
        return this.cpuArch.getLlvmCpu();
    }
}

