/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.clazz;

import org.robovm.compiler.clazz.Dependency;

public abstract class MethodDependency
extends Dependency {
    private static final long serialVersionUID = 1L;
    private final String owner;
    private final String name;
    private final String desc;

    MethodDependency(String owner, String methodName, String methodDesc, String path, boolean inBootClasspath, boolean weak) {
        super(owner, path, inBootClasspath, weak);
        this.owner = owner;
        this.name = methodName;
        this.desc = methodDesc;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getMethodName() {
        return this.name;
    }

    public String getMethodDesc() {
        return this.desc;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.desc == null ? 0 : this.desc.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.owner == null ? 0 : this.owner.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodDependency other = (MethodDependency)obj;
        if (this.desc == null ? other.desc != null : !this.desc.equals(other.desc)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.owner == null ? other.owner != null : !this.owner.equals(other.owner));
    }
}

