/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.robovm.compiler.Functions;
import org.robovm.compiler.Symbols;
import org.robovm.compiler.Types;
import org.robovm.compiler.llvm.ArrayConstantBuilder;
import org.robovm.compiler.llvm.ConstantBitcast;
import org.robovm.compiler.llvm.FunctionRef;
import org.robovm.compiler.llvm.IntegerConstant;
import org.robovm.compiler.llvm.StructureConstant;
import org.robovm.compiler.llvm.StructureConstantBuilder;
import org.robovm.compiler.llvm.Type;
import soot.SootClass;
import soot.SootMethod;

public class VTable {
    private Entry[] entries;

    private VTable(SootClass clazz, VTable parent) {
        LinkedList<Entry> entries = new LinkedList<Entry>();
        for (SootMethod method : clazz.getMethods()) {
            if (method.isStatic() || method.isPrivate() || "<init>".equals(method.getName())) continue;
            entries.add(new Entry(entries.size(), method));
        }
        this.entries = VTable.merge(entries, parent);
    }

    private static Entry[] merge(LinkedList<Entry> childEntries, VTable parent) {
        if (parent == null) {
            return childEntries.toArray(new Entry[childEntries.size()]);
        }
        ArrayList<Entry> result = new ArrayList<Entry>();
        block0: for (Entry entryParent : parent.entries) {
            Iterator it = childEntries.iterator();
            while (it.hasNext()) {
                Entry entryChild = (Entry)it.next();
                if (!entryChild.overrides(entryParent)) continue;
                entryChild.index = entryParent.index;
                result.add(entryChild);
                it.remove();
                continue block0;
            }
            result.add(entryParent);
        }
        for (Entry entry : childEntries) {
            entry.index = result.size();
            result.add(entry);
        }
        return result.toArray(new Entry[result.size()]);
    }

    public StructureConstant getStruct() {
        ArrayConstantBuilder table = new ArrayConstantBuilder(Type.I8_PTR);
        for (Entry entry : this.entries) {
            if (Modifier.isAbstract(entry.getModifiers())) {
                table.add(new ConstantBitcast(Functions.BC_ABSTRACT_METHOD_CALLED, Type.I8_PTR));
                continue;
            }
            table.add(new ConstantBitcast(entry.getFunctionRef(), Type.I8_PTR));
        }
        return new StructureConstantBuilder().add(new IntegerConstant((short)this.entries.length)).add(table.build()).build();
    }

    public Entry[] getEntries() {
        return Arrays.copyOf(this.entries, this.entries.length);
    }

    public int size() {
        return this.entries.length;
    }

    Entry findEntry(String name, String desc) {
        return this.findEntry(null, name, desc);
    }

    Entry findEntry(String paket, String name, String desc) {
        for (Entry entry : this.entries) {
            if (VTable.isPackagePrivate(entry.modifiers) && !entry.paket.equals(paket) || !entry.name.equals(name) || !entry.desc.equals(desc)) continue;
            return entry;
        }
        return null;
    }

    public Entry getEntry(SootMethod method) {
        return this.findEntry(method.getDeclaringClass().getPackageName(), method.getName(), Types.getDescriptor(method));
    }

    private static boolean isPackagePrivate(int modifiers) {
        return (modifiers & 7) == 0;
    }

    public static class Entry {
        private int index;
        private final int modifiers;
        private final String declaringClass;
        private final String paket;
        private final String name;
        private final String desc;

        Entry(int index, SootMethod method) {
            this(index, method.getModifiers(), method.getDeclaringClass().getName(), method.getName(), Types.getDescriptor(method));
        }

        Entry(int index, int modifiers, String declaringClass, String name, String desc) {
            this.index = index;
            this.modifiers = modifiers;
            this.declaringClass = declaringClass;
            this.name = name;
            this.desc = desc;
            int packEndIdx = declaringClass.lastIndexOf(46);
            this.paket = packEndIdx == -1 ? "" : declaringClass.substring(0, packEndIdx);
        }

        public FunctionRef getFunctionRef() {
            if (Modifier.isAbstract(this.modifiers)) {
                return null;
            }
            String owner = this.declaringClass.replace('.', '/');
            String functionName = Modifier.isSynchronized(this.modifiers) ? Symbols.synchronizedWrapperSymbol(owner, this.name, this.desc) : Symbols.methodSymbol(owner, this.name, this.desc);
            return new FunctionRef(functionName, Types.getFunctionType(this.desc, Modifier.isStatic(this.modifiers)));
        }

        public boolean overrides(Entry other) {
            if (other.name.equals(this.name) && other.desc.equals(this.desc)) {
                if (VTable.isPackagePrivate(other.modifiers)) {
                    return other.paket.equals(this.paket);
                }
                return true;
            }
            return false;
        }

        public int getIndex() {
            return this.index;
        }

        public int getModifiers() {
            return this.modifiers;
        }

        public String getPackage() {
            return this.paket;
        }

        public String getDeclaringClass() {
            return this.declaringClass;
        }

        public String getName() {
            return this.name;
        }

        public String getDesc() {
            return this.desc;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Entry [index=").append(this.index).append(", declaringClass=").append(this.declaringClass).append(", name=").append(this.name).append(", desc=").append(this.desc).append("]");
            return builder.toString();
        }
    }

    public static class Cache {
        Map<String, VTable> cache = new HashMap<String, VTable>();

        public VTable get(SootClass clazz) {
            if (clazz.isInterface()) {
                throw new IllegalArgumentException("Expected a class got an interface: " + clazz.getName());
            }
            VTable vtable = this.cache.get(clazz.getName());
            if (vtable != null) {
                return vtable;
            }
            VTable parent = null;
            if (clazz.hasSuperclass()) {
                parent = this.get(clazz.getSuperclass());
            }
            vtable = new VTable(clazz, parent);
            this.cache.put(clazz.getName(), vtable);
            return vtable;
        }
    }
}

