/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler;

import java.util.HashMap;
import java.util.Map;
import org.robovm.compiler.Types;
import org.robovm.compiler.llvm.FunctionRef;
import org.robovm.compiler.llvm.FunctionType;
import org.robovm.compiler.llvm.Type;
import soot.SootFieldRef;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Value;
import soot.jimple.DefinitionStmt;
import soot.jimple.InvokeExpr;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;

public class Intrinsics {
    private static final Map<String, FunctionRef> SIMPLE_INTRINSICS = new HashMap<String, FunctionRef>();
    private static final FunctionRef LDC_PRIM_Z;
    private static final FunctionRef LDC_PRIM_B;
    private static final FunctionRef LDC_PRIM_C;
    private static final FunctionRef LDC_PRIM_S;
    private static final FunctionRef LDC_PRIM_I;
    private static final FunctionRef LDC_PRIM_J;
    private static final FunctionRef LDC_PRIM_F;
    private static final FunctionRef LDC_PRIM_D;

    public static FunctionRef getIntrinsic(SootMethod currMethod, Stmt stmt, InvokeExpr expr) {
        SootMethodRef methodRef = expr.getMethodRef();
        FunctionRef fref = SIMPLE_INTRINSICS.get(Types.getInternalName(methodRef.declaringClass()) + "/" + methodRef.name() + Types.getDescriptor(methodRef));
        if (fref != null) {
            return fref;
        }
        if (methodRef.name().startsWith("memmove") && "org.robovm.rt.VM".equals(methodRef.declaringClass().getName())) {
            return new FunctionRef("intrinsics.org_robovm_rt_VM_" + methodRef.name(), new FunctionType((Type)Type.VOID, Types.ENV_PTR, Type.I64, Type.I64, Type.I64));
        }
        if ("arraycopy".equals(methodRef.name()) && "java.lang.System".equals(methodRef.declaringClass().getName()) && "_getChars".equals(currMethod.getName()) && "java.lang.String".equals(currMethod.getDeclaringClass().getName())) {
            return new FunctionRef("intrinsics.java_lang_System_arraycopy_C", new FunctionType((Type)Type.VOID, Types.ENV_PTR, Types.OBJECT_PTR, Type.I32, Types.OBJECT_PTR, Type.I32, Type.I32));
        }
        return null;
    }

    public static FunctionRef getIntrinsic(SootMethod currMethod, DefinitionStmt stmt) {
        SootFieldRef fieldRef;
        Value rightOp = stmt.getRightOp();
        if (rightOp instanceof StaticFieldRef && "TYPE".equals((fieldRef = ((StaticFieldRef)rightOp).getFieldRef()).name())) {
            String declClass = fieldRef.declaringClass().getName();
            if ("java.lang.Boolean".equals(declClass)) {
                return LDC_PRIM_Z;
            }
            if ("java.lang.Byte".equals(declClass)) {
                return LDC_PRIM_B;
            }
            if ("java.lang.Character".equals(declClass)) {
                return LDC_PRIM_C;
            }
            if ("java.lang.Short".equals(declClass)) {
                return LDC_PRIM_S;
            }
            if ("java.lang.Integer".equals(declClass)) {
                return LDC_PRIM_I;
            }
            if ("java.lang.Long".equals(declClass)) {
                return LDC_PRIM_J;
            }
            if ("java.lang.Float".equals(declClass)) {
                return LDC_PRIM_F;
            }
            if ("java.lang.Double".equals(declClass)) {
                return LDC_PRIM_D;
            }
        }
        return null;
    }

    static {
        SIMPLE_INTRINSICS.put("java/lang/Class/getSuperclass()Ljava/lang/Class;", new FunctionRef("intrinsics.java_lang_Class_getSuperclass", new FunctionType(Types.OBJECT_PTR, Types.ENV_PTR, Types.OBJECT_PTR)));
        SIMPLE_INTRINSICS.put("java/lang/Class/getComponentType()Ljava/lang/Class;", new FunctionRef("intrinsics.java_lang_Class_getComponentType", new FunctionType(Types.OBJECT_PTR, Types.ENV_PTR, Types.OBJECT_PTR)));
        SIMPLE_INTRINSICS.put("java/lang/Class/isArray()Z", new FunctionRef("intrinsics.java_lang_Class_isArray", new FunctionType((Type)Type.I8, Types.ENV_PTR, Types.OBJECT_PTR)));
        SIMPLE_INTRINSICS.put("java/lang/Class/isPrimitive()Z", new FunctionRef("intrinsics.java_lang_Class_isPrimitive", new FunctionType((Type)Type.I8, Types.ENV_PTR, Types.OBJECT_PTR)));
        SIMPLE_INTRINSICS.put("java/lang/Object/getClass()Ljava/lang/Class;", new FunctionRef("intrinsics.java_lang_Object_getClass", new FunctionType(Types.OBJECT_PTR, Types.ENV_PTR, Types.OBJECT_PTR)));
        SIMPLE_INTRINSICS.put("java/lang/Math/abs(F)F", new FunctionRef("intrinsics.java_lang_Math_abs_F", new FunctionType((Type)Type.FLOAT, Types.ENV_PTR, Type.FLOAT)));
        SIMPLE_INTRINSICS.put("java/lang/Math/abs(D)D", new FunctionRef("intrinsics.java_lang_Math_abs_D", new FunctionType((Type)Type.DOUBLE, Types.ENV_PTR, Type.DOUBLE)));
        SIMPLE_INTRINSICS.put("java/lang/Math/sqrt(D)D", new FunctionRef("intrinsics.java_lang_Math_sqrt", new FunctionType((Type)Type.DOUBLE, Types.ENV_PTR, Type.DOUBLE)));
        SIMPLE_INTRINSICS.put("java/lang/Math/cos(D)D", new FunctionRef("intrinsics.java_lang_Math_cos", new FunctionType((Type)Type.DOUBLE, Types.ENV_PTR, Type.DOUBLE)));
        SIMPLE_INTRINSICS.put("java/lang/Math/sin(D)D", new FunctionRef("intrinsics.java_lang_Math_sin", new FunctionType((Type)Type.DOUBLE, Types.ENV_PTR, Type.DOUBLE)));
        LDC_PRIM_Z = new FunctionRef("intrinsics.ldc_prim_Z", new FunctionType(Types.OBJECT_PTR, Types.ENV_PTR));
        LDC_PRIM_B = new FunctionRef("intrinsics.ldc_prim_B", new FunctionType(Types.OBJECT_PTR, Types.ENV_PTR));
        LDC_PRIM_C = new FunctionRef("intrinsics.ldc_prim_C", new FunctionType(Types.OBJECT_PTR, Types.ENV_PTR));
        LDC_PRIM_S = new FunctionRef("intrinsics.ldc_prim_S", new FunctionType(Types.OBJECT_PTR, Types.ENV_PTR));
        LDC_PRIM_I = new FunctionRef("intrinsics.ldc_prim_I", new FunctionType(Types.OBJECT_PTR, Types.ENV_PTR));
        LDC_PRIM_J = new FunctionRef("intrinsics.ldc_prim_J", new FunctionType(Types.OBJECT_PTR, Types.ENV_PTR));
        LDC_PRIM_F = new FunctionRef("intrinsics.ldc_prim_F", new FunctionType(Types.OBJECT_PTR, Types.ENV_PTR));
        LDC_PRIM_D = new FunctionRef("intrinsics.ldc_prim_D", new FunctionType(Types.OBJECT_PTR, Types.ENV_PTR));
    }
}

