/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import org.robovm.compiler.Bro;
import org.robovm.compiler.BroMethodCompiler;
import org.robovm.compiler.FunctionBuilder;
import org.robovm.compiler.Functions;
import org.robovm.compiler.MarshalerLookup;
import org.robovm.compiler.ModuleBuilder;
import org.robovm.compiler.Symbols;
import org.robovm.compiler.Types;
import org.robovm.compiler.config.Config;
import org.robovm.compiler.llvm.Alias;
import org.robovm.compiler.llvm.BasicBlockRef;
import org.robovm.compiler.llvm.ConstantBitcast;
import org.robovm.compiler.llvm.DataLayout;
import org.robovm.compiler.llvm.Function;
import org.robovm.compiler.llvm.FunctionDeclaration;
import org.robovm.compiler.llvm.FunctionRef;
import org.robovm.compiler.llvm.FunctionType;
import org.robovm.compiler.llvm.IntegerConstant;
import org.robovm.compiler.llvm.Label;
import org.robovm.compiler.llvm.Linkage;
import org.robovm.compiler.llvm.PointerType;
import org.robovm.compiler.llvm.PrimitiveType;
import org.robovm.compiler.llvm.Ret;
import org.robovm.compiler.llvm.StructureType;
import org.robovm.compiler.llvm.Type;
import org.robovm.compiler.llvm.Unreachable;
import org.robovm.compiler.llvm.Value;
import org.robovm.compiler.trampoline.Invokestatic;
import soot.SootMethod;

public class CallbackMethodCompiler
extends BroMethodCompiler {
    public CallbackMethodCompiler(Config config) {
        super(config);
    }

    @Override
    protected Function doCompile(ModuleBuilder moduleBuilder, SootMethod method) {
        return this.compileCallback(moduleBuilder, method);
    }

    protected FunctionRef getCallbackCWrapperRef(SootMethod method, String name) {
        return new FunctionRef(name, this.getCallbackFunctionType(method, false));
    }

    protected static String createCallbackCWrapper(FunctionType functionType, String name, String innerName) {
        TreeMap<String, String> typedefs = new TreeMap<String, String>(Collections.reverseOrder());
        StringBuilder hiSignature = new StringBuilder();
        hiSignature.append(CallbackMethodCompiler.getHiType(functionType.getReturnType())).append(' ').append(innerName).append('(');
        StringBuilder loSignature = new StringBuilder();
        String loReturnType = CallbackMethodCompiler.getLoType(functionType.getReturnType(), name, 0, typedefs);
        loSignature.append(loReturnType).append(' ').append(name).append('(');
        StringBuilder body = new StringBuilder(" {\n");
        StringBuilder args = new StringBuilder();
        for (int i = 0; i < functionType.getParameterTypes().length; ++i) {
            String arg = "p" + i;
            if (i > 0) {
                hiSignature.append(", ");
                loSignature.append(", ");
                args.append(", ");
            }
            String hiParamType = CallbackMethodCompiler.getHiType(functionType.getParameterTypes()[i]);
            hiSignature.append(hiParamType);
            String loParamType = CallbackMethodCompiler.getLoType(functionType.getParameterTypes()[i], name, i + 1, typedefs);
            loSignature.append(loParamType).append(' ').append(arg);
            if (functionType.getParameterTypes()[i] instanceof StructureType) {
                args.append("(void*) &").append(arg);
                continue;
            }
            args.append(arg);
        }
        if (functionType.getParameterTypes().length == 0) {
            hiSignature.append("void");
            loSignature.append("void");
        }
        hiSignature.append(')');
        loSignature.append(')');
        StringBuilder header = new StringBuilder();
        for (String typedef : typedefs.values()) {
            header.append(typedef + "\n");
        }
        header.append(hiSignature + ";\n");
        if (functionType.getReturnType() instanceof StructureType) {
            body.append("    return *((" + loReturnType + "*) " + innerName + "(" + args + "));\n");
        } else if (functionType.getReturnType() != Type.VOID) {
            body.append("    return " + innerName + "(" + args + ");\n");
        } else {
            body.append("    " + innerName + "(" + args + ");\n");
        }
        body.append("}\n");
        return header.toString() + loSignature.toString() + body.toString();
    }

    private Function compileCallback(ModuleBuilder moduleBuilder, SootMethod method) {
        Value arg;
        Function callbackFn = null;
        FunctionType nativeFnType = null;
        boolean useCWrapper = this.requiresCWrapper(method);
        if (useCWrapper) {
            FunctionRef callbackCWrapperRef = this.getCallbackCWrapperRef(method, Symbols.callbackCSymbol(method));
            this.getCWrapperFunctions().add(CallbackMethodCompiler.createCallbackCWrapper(callbackCWrapperRef.getType(), callbackCWrapperRef.getName(), Symbols.callbackInnerCSymbol(method)));
            moduleBuilder.addFunctionDeclaration(new FunctionDeclaration(callbackCWrapperRef));
            PointerType callbackRetType = callbackCWrapperRef.getType().getReturnType() instanceof StructureType ? Type.I8_PTR : callbackCWrapperRef.getType().getReturnType();
            Type[] callbackParamTypes = new Type[callbackCWrapperRef.getType().getParameterTypes().length];
            for (int i = 0; i < callbackParamTypes.length; ++i) {
                Type t = callbackCWrapperRef.getType().getParameterTypes()[i];
                if (t instanceof StructureType) {
                    t = Type.I8_PTR;
                }
                callbackParamTypes[i] = t;
            }
            moduleBuilder.addAlias(new Alias(Symbols.callbackPtrSymbol(method), Linkage._private, new ConstantBitcast(callbackCWrapperRef, Type.I8_PTR)));
            callbackFn = new FunctionBuilder(Symbols.callbackInnerCSymbol(method), new FunctionType((Type)callbackRetType, callbackParamTypes)).build();
            nativeFnType = callbackCWrapperRef.getType();
        } else {
            FunctionType callbackFnType = this.getCallbackFunctionType(method, false);
            callbackFn = FunctionBuilder.callback(method, callbackFnType);
            moduleBuilder.addAlias(new Alias(Symbols.callbackPtrSymbol(method), Linkage._private, new ConstantBitcast(callbackFn.ref(), Type.I8_PTR)));
            nativeFnType = callbackFnType;
        }
        moduleBuilder.addFunction(callbackFn);
        String targetName = method.isSynchronized() ? Symbols.synchronizedWrapperSymbol(method) : Symbols.methodSymbol(method);
        FunctionRef targetFn = new FunctionRef(targetName, Types.getFunctionType(method));
        Value env = Functions.call(callbackFn, (Value)Functions.BC_ATTACH_THREAD_FROM_CALLBACK, new Value[0]);
        BasicBlockRef bbSuccess = callbackFn.newBasicBlockRef(new Label("success"));
        BasicBlockRef bbFailure = callbackFn.newBasicBlockRef(new Label("failure"));
        Functions.pushCallbackFrame(callbackFn, env);
        Functions.trycatchAllEnter(callbackFn, env, bbSuccess, bbFailure);
        callbackFn.newBasicBlock(bbSuccess.getLabel());
        ArrayList<BroMethodCompiler.MarshaledArg> marshaledArgs = new ArrayList<BroMethodCompiler.MarshaledArg>();
        ArrayList<Value> args = new ArrayList<Value>();
        args.add(env);
        if (!method.isStatic()) {
            MarshalerLookup.MarshalerMethod marshalerMethod = this.config.getMarshalerLookup().findMarshalerMethod(new MarshalerLookup.MarshalSite(method, -2));
            BroMethodCompiler.MarshaledArg marshaledArg = new BroMethodCompiler.MarshaledArg();
            marshaledArg.paramIndex = -2;
            marshaledArgs.add(marshaledArg);
            arg = callbackFn.getParameterRef(0);
            String targetClassName = Types.getInternalName(method.getDeclaringClass());
            arg = this.marshalNativeToObject(callbackFn, marshalerMethod, marshaledArg, env, targetClassName, arg, 1L);
            args.add(arg);
        }
        int i = 0;
        int argIdx = 0;
        while (i < method.getParameterCount()) {
            if (!method.isStatic() && argIdx == 0) {
                ++argIdx;
            }
            arg = callbackFn.getParameterRef(argIdx);
            soot.Type type = method.getParameterType(i);
            if (Bro.needsMarshaler(type)) {
                MarshalerLookup.MarshalerMethod marshalerMethod = this.config.getMarshalerLookup().findMarshalerMethod(new MarshalerLookup.MarshalSite(method, i));
                String targetClassName = Types.getInternalName(type);
                if (arg.getType() instanceof PrimitiveType) {
                    arg = this.marshalNativeToValueObject(callbackFn, marshalerMethod, env, targetClassName, arg, 1L);
                } else {
                    BroMethodCompiler.MarshaledArg marshaledArg = new BroMethodCompiler.MarshaledArg();
                    marshaledArg.paramIndex = i;
                    marshaledArgs.add(marshaledArg);
                    Type nativeType = nativeFnType.getParameterTypes()[argIdx];
                    if (nativeType instanceof StructureType) {
                        DataLayout dataLayout = this.config.getDataLayout();
                        Value heapCopy = Functions.call(callbackFn, (Value)Functions.BC_COPY_STRUCT, env, arg, new IntegerConstant(dataLayout.getAllocSize(nativeType)));
                        arg = this.marshalNativeToObject(callbackFn, marshalerMethod, marshaledArg, env, targetClassName, heapCopy, 1L);
                    } else {
                        arg = this.marshalNativeToObject(callbackFn, marshalerMethod, marshaledArg, env, targetClassName, arg, 1L);
                    }
                }
            } else {
                arg = this.marshalNativeToPrimitive(callbackFn, method, i, arg);
            }
            args.add(arg);
            ++i;
            ++argIdx;
        }
        Value result = Functions.call(callbackFn, (Value)targetFn, args);
        this.updateNative(method, callbackFn, env, 1L, marshaledArgs);
        if (Bro.needsMarshaler(method.getReturnType())) {
            MarshalerLookup.MarshalerMethod marshalerMethod = this.config.getMarshalerLookup().findMarshalerMethod(new MarshalerLookup.MarshalSite(method));
            Type nativeType = callbackFn.getType().getReturnType();
            result = nativeType instanceof PrimitiveType ? this.marshalValueObjectToNative(callbackFn, marshalerMethod, nativeType, env, result, 1L) : this.marshalObjectToNative(callbackFn, marshalerMethod, null, nativeType, env, result, 1L);
        } else {
            result = this.marshalPrimitiveToNative(callbackFn, method, result);
        }
        Functions.trycatchLeave(callbackFn, env);
        Functions.popCallbackFrame(callbackFn, env);
        Functions.call(callbackFn, (Value)Functions.BC_DETACH_THREAD_FROM_CALLBACK, env);
        callbackFn.add(new Ret(result));
        callbackFn.newBasicBlock(bbFailure.getLabel());
        Functions.trycatchLeave(callbackFn, env);
        Functions.popCallbackFrame(callbackFn, env);
        Value ex = Functions.call(callbackFn, (Value)Functions.BC_EXCEPTION_CLEAR, env);
        this.updateNative(method, callbackFn, env, 1L, marshaledArgs);
        Functions.call(callbackFn, (Value)Functions.BC_DETACH_THREAD_FROM_CALLBACK, env);
        Functions.call(callbackFn, (Value)Functions.BC_THROW, env, ex);
        callbackFn.add(new Unreachable());
        return callbackFn;
    }

    private void updateNative(SootMethod method, Function fn, Value env, long flags, List<BroMethodCompiler.MarshaledArg> marshaledArgs) {
        for (BroMethodCompiler.MarshaledArg value : marshaledArgs) {
            MarshalerLookup.MarshalerMethod marshalerMethod = this.config.getMarshalerLookup().findMarshalerMethod(new MarshalerLookup.MarshalSite(method, value.paramIndex));
            SootMethod afterMethod = ((MarshalerLookup.PointerMarshalerMethod)marshalerMethod).getAfterCallbackCallMethod();
            if (afterMethod == null) continue;
            Invokestatic invokestatic = new Invokestatic(Types.getInternalName(method.getDeclaringClass()), Types.getInternalName(afterMethod.getDeclaringClass()), afterMethod.getName(), Types.getDescriptor(afterMethod));
            this.trampolines.add(invokestatic);
            Functions.call(fn, (Value)invokestatic.getFunctionRef(), env, value.handle, value.object, new IntegerConstant(flags));
        }
    }
}

