/*
 * Decompiled with CFR 0.152.
 */
package com.lewisd.maven.lint.util;

import com.lewisd.maven.lint.model.Coordinates;
import com.lewisd.maven.lint.model.ExtDependency;
import com.lewisd.maven.lint.model.ExtPlugin;
import com.lewisd.maven.lint.model.ObjectWithPath;
import com.lewisd.maven.lint.util.ExpressionEvaluator;
import com.lewisd.maven.lint.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.springframework.beans.factory.annotation.Autowired;

public class ModelUtil {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private final ReflectionUtil reflectionUtil;
    private final ExpressionEvaluator expressionEvaluator;
    private final Log log;

    @Autowired
    public ModelUtil(ReflectionUtil reflectionUtil, ExpressionEvaluator expressionEvaluator, Log log) {
        this.reflectionUtil = reflectionUtil;
        this.expressionEvaluator = expressionEvaluator;
        this.log = log;
    }

    public InputLocation getLocation(Object modelObject) {
        return this.getLocation(modelObject, "");
    }

    public InputLocation getLocation(Object modelObject, Object key) {
        String methodName = "getLocation";
        return (InputLocation)this.reflectionUtil.callMethod(modelObject, "getLocation", new Class[]{Object.class}, new Object[]{key});
    }

    public String getVersion(Object modelObject) {
        String methodName = "getVersion";
        return (String)this.reflectionUtil.callMethod(modelObject, "getVersion", EMPTY_CLASS_ARRAY, EMPTY_OBJECT_ARRAY);
    }

    public String getArtifactId(Object modelObject) {
        String methodName = "getArtifactId";
        return (String)this.reflectionUtil.callMethod(modelObject, "getArtifactId", EMPTY_CLASS_ARRAY, EMPTY_OBJECT_ARRAY);
    }

    public String getGroupId(Object modelObject) {
        String methodName = "getGroupId";
        return (String)this.reflectionUtil.callMethod(modelObject, "getGroupId", EMPTY_CLASS_ARRAY, EMPTY_OBJECT_ARRAY);
    }

    public String getType(Object modelObject) {
        String methodName = "getType";
        return (String)this.reflectionUtil.callMethod(modelObject, "getType", EMPTY_CLASS_ARRAY, EMPTY_OBJECT_ARRAY);
    }

    public String tryGetType(Object modelObject) {
        try {
            return this.getType(modelObject);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public String getClassifier(Object modelObject) {
        String methodName = "getClassifier";
        return (String)this.reflectionUtil.callMethod(modelObject, "getClassifier", EMPTY_CLASS_ARRAY, EMPTY_OBJECT_ARRAY);
    }

    public String tryGetClassifier(Object modelObject) {
        try {
            return this.getClassifier(modelObject);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public String getKey(Object modelObject) {
        if (modelObject instanceof Dependency) {
            return ((Dependency)modelObject).getManagementKey();
        }
        if (modelObject instanceof Plugin) {
            return ((Plugin)modelObject).getKey();
        }
        throw new IllegalArgumentException("Unknown object type: " + modelObject.getClass());
    }

    public Map<Object, InputLocation> getLocations(Object modelObject) {
        Dependency dependency;
        List exclusions;
        Class<?> klass = modelObject.getClass();
        Map<Object, InputLocation> locations = this.getLocations(modelObject, klass);
        if (modelObject instanceof Plugin) {
            Plugin plugin = (Plugin)modelObject;
            List executions = plugin.getExecutions();
            if (executions != null && !executions.isEmpty()) {
                PluginExecution pluginExecution = (PluginExecution)executions.get(0);
                InputLocation location = pluginExecution.getLocation((Object)"");
                if (location != null) {
                    locations.put("execution", location);
                } else {
                    this.log.warn((CharSequence)("Unable to determine location for " + pluginExecution));
                }
            }
        } else if (modelObject instanceof Dependency && (exclusions = (dependency = (Dependency)modelObject).getExclusions()) != null && !exclusions.isEmpty()) {
            Exclusion exclusion = (Exclusion)exclusions.get(0);
            InputLocation location = exclusion.getLocation((Object)"");
            if (location != null) {
                locations.put("exclusion", location);
            } else {
                this.log.warn((CharSequence)("Unable to determine location for " + exclusion));
            }
        }
        return locations;
    }

    public Collection<Object> findGAVObjects(MavenProject mavenProject) {
        LinkedList<Object> objects = new LinkedList<Object>();
        Model originalModel = mavenProject.getOriginalModel();
        objects.add(originalModel);
        objects.addAll(this.expressionEvaluator.getPath(originalModel, "dependencies"));
        objects.addAll(this.expressionEvaluator.getPath(originalModel, "dependencyManagement/dependencies"));
        objects.addAll(this.expressionEvaluator.getPath(originalModel, "build/plugins"));
        objects.addAll(this.expressionEvaluator.getPath(originalModel, "build/plugins/dependencies"));
        objects.addAll(this.expressionEvaluator.getPath(originalModel, "build/pluginManagement/plugins"));
        objects.addAll(this.expressionEvaluator.getPath(originalModel, "build/pluginManagement/plugins/dependencies"));
        return objects;
    }

    private Map<Object, InputLocation> getLocations(Object modelObject, Class klass) {
        try {
            Field field = klass.getDeclaredField("locations");
            field.setAccessible(true);
            HashMap<Object, InputLocation> locations = new HashMap<Object, InputLocation>();
            Map locationsFieldValue = (Map)field.get(modelObject);
            for (Map.Entry entry : locationsFieldValue.entrySet()) {
                if (entry.getValue() != null) {
                    locations.put(entry.getKey(), (InputLocation)entry.getValue());
                    continue;
                }
                this.log.warn((CharSequence)("Unable to determine location for " + entry.getKey()));
            }
            return locations;
        }
        catch (NoSuchFieldException e) {
            if (klass.getSuperclass() == null) {
                throw new IllegalArgumentException("No 'locations' field found on object of type " + klass, e);
            }
            return this.getLocations(modelObject, klass.getSuperclass());
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException("Failed to get 'locations' field on object of type " + klass, e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Failed to get 'locations' field on object of type " + klass, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Failed to get 'locations' field on object of type " + klass, e);
        }
    }

    public Map<String, Dependency> mapByManagementKey(Collection<Dependency> dependencies) {
        HashMap<String, Dependency> map = new HashMap<String, Dependency>();
        for (Dependency dependency : dependencies) {
            map.put(dependency.getManagementKey(), dependency);
        }
        return map;
    }

    public Map<String, Plugin> mapById(Collection<Plugin> dependencies) {
        HashMap<String, Plugin> map = new HashMap<String, Plugin>();
        for (Plugin plugin : dependencies) {
            map.put(plugin.getId(), plugin);
        }
        return map;
    }

    public ObjectWithPath<ExtDependency> findInheritedDependency(MavenProject mavenProject, Dependency dependency) {
        MavenProject parent = mavenProject.getParent();
        if (parent != null) {
            Map<String, Dependency> dependencies = this.mapByManagementKey(this.expressionEvaluator.getPath(parent.getOriginalModel(), "dependencies"));
            Map<String, Dependency> managedDependencies = this.mapByManagementKey(this.expressionEvaluator.getPath(parent.getOriginalModel(), "dependencyManagement/dependencies"));
            Dependency parentDependency = dependencies.get(dependency.getManagementKey());
            if (parentDependency != null) {
                return new ObjectWithPath<ExtDependency>(new ExtDependency(parent, parentDependency), parent, "dependencies");
            }
            Dependency parentManagedDependency = managedDependencies.get(dependency.getManagementKey());
            if (parentManagedDependency != null) {
                return new ObjectWithPath<ExtDependency>(new ExtDependency(parent, parentManagedDependency), parent, "dependencyManagement/dependencies");
            }
            return this.findInheritedDependency(parent, dependency);
        }
        return null;
    }

    public List<ObjectWithPath<ExtPlugin>> findInheritedPlugins(MavenProject mavenProject, Plugin plugin) {
        LinkedList<ObjectWithPath<ExtPlugin>> inheritedPlugins = new LinkedList<ObjectWithPath<ExtPlugin>>();
        this.findInheritedPlugins(inheritedPlugins, mavenProject, plugin);
        return inheritedPlugins;
    }

    private void findInheritedPlugins(List<ObjectWithPath<ExtPlugin>> inheritedPlugins, MavenProject mavenProject, Plugin plugin) {
        MavenProject parent = mavenProject.getParent();
        if (parent != null) {
            Plugin parentManagedPlugin;
            Map<String, Plugin> plugins = this.mapById(this.expressionEvaluator.getPath(parent.getOriginalModel(), "build/plugins"));
            Map<String, Plugin> managedPlugins = this.mapById(this.expressionEvaluator.getPath(parent.getOriginalModel(), "build/pluginManagement/plugins"));
            Plugin parentPlugin = plugins.get(plugin.getId());
            if (parentPlugin != null) {
                inheritedPlugins.add(new ObjectWithPath<ExtPlugin>(new ExtPlugin(parent, parentPlugin), parent, "build/plugins"));
            }
            if ((parentManagedPlugin = managedPlugins.get(plugin.getId())) != null) {
                inheritedPlugins.add(new ObjectWithPath<ExtPlugin>(new ExtPlugin(parent, parentManagedPlugin), parent, "build/pluginManagement/plugins"));
            }
            this.findInheritedPlugins(inheritedPlugins, parent, plugin);
        }
    }

    public Coordinates getCoordinates(Object modelObject) {
        String groupId = this.getGroupId(modelObject);
        String artifactId = this.getArtifactId(modelObject);
        String type = this.tryGetType(modelObject);
        String version = this.getVersion(modelObject);
        return new Coordinates(groupId, artifactId, type, version);
    }
}

