/*
 * Decompiled with CFR 0.152.
 */
package com.lewisd.maven.lint.rules.opensource;

import com.lewisd.maven.lint.ResultCollector;
import com.lewisd.maven.lint.rules.AbstractRule;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.InputSource;
import org.apache.maven.project.MavenProject;

public class MissingUrlRule
extends AbstractRule {
    @Override
    public String getIdentifier() {
        return "OSSUrlSectionRule";
    }

    @Override
    public String getDescription() {
        return "For better understanding the project a link to your project is required.";
    }

    @Override
    public void invoke(MavenProject mavenProject, Map<String, Object> models, ResultCollector resultCollector) {
        String url = mavenProject.getUrl();
        if (StringUtils.isEmpty((String)url)) {
            resultCollector.addViolation(mavenProject, this, "missing <url/> information", this.getEmptyLocation(mavenProject));
        }
    }

    private InputLocation getEmptyLocation(MavenProject mavenProject) {
        InputSource source = new InputSource();
        source.setLocation(mavenProject.getOriginalModel().getPomFile() + "");
        return new InputLocation(0, 0, source);
    }
}

