/*
 * Decompiled with CFR 0.152.
 */
package com.lewisd.maven.lint.rules.opensource;

import com.lewisd.maven.lint.ResultCollector;
import com.lewisd.maven.lint.rules.AbstractRule;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.InputSource;
import org.apache.maven.project.MavenProject;

public class MissingInceptionYearRule
extends AbstractRule {
    @Override
    public String getIdentifier() {
        return "OSSInceptionYearRule";
    }

    @Override
    public String getDescription() {
        return "For better understanding the project the inception year of your project is required.";
    }

    @Override
    public void invoke(MavenProject mavenProject, Map<String, Object> models, ResultCollector resultCollector) {
        String inceptionYear = mavenProject.getInceptionYear();
        if (StringUtils.isEmpty((String)inceptionYear)) {
            resultCollector.addViolation(mavenProject, this, "missing <inceptionYear/> information", this.getEmptyLocation(mavenProject));
        } else if (!inceptionYear.matches("\\d{4}")) {
            InputLocation location = mavenProject.getOriginalModel().getLocation((Object)"inceptionYear");
            resultCollector.addViolation(mavenProject, this, "format of <inceptionYear/> information is wrong, only 4 digits allowed", location);
        }
    }

    private InputLocation getEmptyLocation(MavenProject mavenProject) {
        InputSource source = new InputSource();
        source.setLocation(mavenProject.getOriginalModel().getPomFile() + "");
        return new InputLocation(0, 0, source);
    }
}

