/*
 * Decompiled with CFR 0.152.
 */
package com.lewisd.maven.lint.rules.basic;

import com.lewisd.maven.lint.ResultCollector;
import com.lewisd.maven.lint.model.VersionProperty;
import com.lewisd.maven.lint.rules.AbstractRule;
import com.lewisd.maven.lint.util.ExpressionEvaluator;
import com.lewisd.maven.lint.util.ModelUtil;
import java.util.Map;
import java.util.Set;
import org.apache.maven.model.InputLocation;
import org.apache.maven.project.MavenProject;
import org.springframework.beans.factory.annotation.Autowired;

public class VersionPropertiesMustUseProjectVersionRule
extends AbstractRule {
    @Autowired
    public VersionPropertiesMustUseProjectVersionRule(ExpressionEvaluator expressionEvaluator, ModelUtil modelUtil) {
        super(expressionEvaluator, modelUtil);
    }

    @Override
    protected void addRequiredModels(Set<String> requiredModels) {
        requiredModels.add("versionProperties");
    }

    @Override
    public String getIdentifier() {
        return "VersionProp";
    }

    @Override
    public String getDescription() {
        return "The ${version} property is deprecated.  Use ${project.version} instead.";
    }

    @Override
    public void invoke(MavenProject mavenProject, Map<String, Object> models, ResultCollector resultCollector) {
        Map versionPropertyByObject = (Map)models.get("versionProperties");
        for (Map.Entry entry : versionPropertyByObject.entrySet()) {
            VersionProperty versionProperty = (VersionProperty)entry.getValue();
            for (String propertyName : versionProperty.getPropertyNames()) {
                if (!propertyName.equals("version")) continue;
                InputLocation location = this.modelUtil.getLocation(entry.getKey(), "version");
                resultCollector.addViolation(mavenProject, this, "Use '${project.version}' instead of '${version}'", location);
            }
        }
    }
}

