/*
 * Decompiled with CFR 0.152.
 */
package com.lewisd.maven.lint.rules.basic;

import com.lewisd.maven.lint.ResultCollector;
import com.lewisd.maven.lint.model.ExtDependency;
import com.lewisd.maven.lint.model.ObjectWithPath;
import com.lewisd.maven.lint.rules.AbstractReduntantVersionRule;
import com.lewisd.maven.lint.util.ExpressionEvaluator;
import com.lewisd.maven.lint.util.ModelUtil;
import java.util.Collection;
import java.util.Map;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.project.MavenProject;
import org.springframework.beans.factory.annotation.Autowired;

public class RedundantDependencyVersionsRule
extends AbstractReduntantVersionRule {
    @Autowired
    public RedundantDependencyVersionsRule(ExpressionEvaluator expressionEvaluator, ModelUtil modelUtil, PluginParameterExpressionEvaluator pluginParameterExpressionEvaluator) {
        super(expressionEvaluator, modelUtil, pluginParameterExpressionEvaluator);
    }

    @Override
    public String getIdentifier() {
        return "RedundantDepVersion";
    }

    @Override
    public String getDescription() {
        return "Dependency versions should be set in one place, and not overridden without changing the version. If, for example, <dependencyManagement> sets a version, and <dependencies> somewhere overrides it, but with the same version, this can make version upgrades more difficult, due to the repetition.";
    }

    @Override
    public void invoke(MavenProject mavenProject, Map<String, Object> models, ResultCollector resultCollector) {
        Model originalModel = mavenProject.getOriginalModel();
        Collection dependencies = this.expressionEvaluator.getPath(originalModel, "dependencies");
        Collection<Dependency> managedDependencies = this.expressionEvaluator.getPath(originalModel, "dependencyManagement/dependencies");
        Map<String, Dependency> managedDependenciesByManagementKey = this.modelUtil.mapByManagementKey(managedDependencies);
        for (Dependency dependency : dependencies) {
            ObjectWithPath<ExtDependency> inheritedDependency;
            Dependency managedDependency = managedDependenciesByManagementKey.get(dependency.getManagementKey());
            if (managedDependency != null) {
                this.checkForRedundantVersions(mavenProject, resultCollector, new ObjectWithPath<Dependency>(dependency, mavenProject, "dependencies"), new ObjectWithPath<Dependency>(managedDependency, mavenProject, "dependencyManagement/dependencies"), "Dependency", "in dependencyManagement");
            }
            if ((inheritedDependency = this.modelUtil.findInheritedDependency(mavenProject, dependency)) == null) continue;
            this.checkForRedundantVersions(mavenProject, resultCollector, new ObjectWithPath<Dependency>(dependency, mavenProject, "dependencies"), inheritedDependency, "Dependency", "is inherited from " + inheritedDependency.getProject().getId());
        }
        for (Dependency managedDependency : managedDependencies) {
            ObjectWithPath<ExtDependency> inheritedDependency = this.modelUtil.findInheritedDependency(mavenProject, managedDependency);
            if (inheritedDependency == null) continue;
            this.checkForRedundantVersions(mavenProject, resultCollector, new ObjectWithPath<Dependency>(managedDependency, mavenProject, "dependencyManagement/dependencies"), inheritedDependency, "Managed dependency", "is inherited from " + inheritedDependency.getProject().getId());
        }
    }
}

