/*
 * Decompiled with CFR 0.152.
 */
package com.lewisd.maven.lint.rules.basic;

import com.lewisd.maven.lint.ResultCollector;
import com.lewisd.maven.lint.rules.AbstractReduntantVersionRule;
import com.lewisd.maven.lint.util.ExpressionEvaluator;
import com.lewisd.maven.lint.util.ModelUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.project.MavenProject;
import org.springframework.beans.factory.annotation.Autowired;

public class ExecutionIdRule
extends AbstractReduntantVersionRule {
    @Autowired
    public ExecutionIdRule(ExpressionEvaluator expressionEvaluator, ModelUtil modelUtil, PluginParameterExpressionEvaluator pluginParameterExpressionEvaluator) {
        super(expressionEvaluator, modelUtil, pluginParameterExpressionEvaluator);
    }

    @Override
    public String getIdentifier() {
        return "ExecutionId";
    }

    @Override
    public String getDescription() {
        return "Executions should always specify an id, so they can be overridden in child modules, and uniquely identified in build logs.";
    }

    @Override
    public void invoke(MavenProject mavenProject, Map<String, Object> models, ResultCollector resultCollector) {
        Model originalModel = mavenProject.getOriginalModel();
        ArrayList plugins = new ArrayList();
        this.expressionEvaluator.getPath(originalModel, "/build/plugins/plugin");
        plugins.addAll(this.expressionEvaluator.getPath(originalModel, "/build/plugins"));
        plugins.addAll(this.expressionEvaluator.getPath(originalModel, "/build/pluginManagement/plugins"));
        plugins.addAll(this.expressionEvaluator.getPath(originalModel, "/profiles/build/plugins"));
        plugins.addAll(this.expressionEvaluator.getPath(originalModel, "/profiles/build/pluginManagement/plugins"));
        for (Plugin plugin : plugins) {
            Collection executions = this.expressionEvaluator.getPath(plugin, "/executions");
            for (PluginExecution execution : executions) {
                if (!StringUtils.isEmpty((String)execution.getId()) && !"default".equals(execution.getId())) continue;
                InputLocation location = this.modelUtil.getLocation(execution, "");
                resultCollector.addViolation(mavenProject, this, "Executions must specify an id", location);
            }
        }
    }
}

