/*
 * Decompiled with CFR 0.152.
 */
package com.lewisd.maven.lint.report.html;

import com.lewisd.maven.lint.Violation;
import com.lewisd.maven.lint.report.AbstractReportWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Properties;
import org.apache.maven.project.MavenProject;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.tools.generic.EscapeTool;

public class HtmlResultWriter
extends AbstractReportWriter {
    @Override
    public void writeResults(MavenProject mavenProject, List<Violation> violations, File outputFile) {
        FileWriter writer = null;
        try {
            writer = this.createOutputFileWriter(outputFile);
            VelocityEngine ve = this.initializeVelocity();
            this.renderHtml(writer, ve, mavenProject, violations);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while writing results to " + outputFile, e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Error while trying to close file " + outputFile, e);
                }
            }
        }
    }

    private VelocityEngine initializeVelocity() {
        VelocityEngine ve = new VelocityEngine();
        Properties properties = this.getVelocityProperties();
        ve.init(properties);
        return ve;
    }

    private Properties getVelocityProperties() {
        Properties properties = new Properties();
        properties.setProperty("resource.loader", "class");
        properties.setProperty("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        return properties;
    }

    private VelocityContext getVelocityContext(MavenProject mavenProject, List<Violation> violations) {
        VelocityContext context = new VelocityContext();
        context.put("project", (Object)mavenProject);
        context.put("violations", violations);
        context.put("esc", (Object)new EscapeTool());
        return context;
    }

    private void renderHtml(FileWriter writer, VelocityEngine ve, MavenProject mavenProject, List<Violation> violations) {
        Template template = ve.getTemplate("velocity/html-report.vm");
        VelocityContext context = this.getVelocityContext(mavenProject, violations);
        template.merge((Context)context, (Writer)writer);
    }
}

