/*
 * Decompiled with CFR 0.152.
 */
package com.lewisd.maven.lint.plugin;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.lewisd.maven.lint.Rule;
import com.lewisd.maven.lint.plugin.PatternSetUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.maven.model.PatternSet;

public class RulesSelector {
    private final Set<Rule> availableRules;

    public RulesSelector(Set<Rule> availableRules) {
        this.availableRules = availableRules;
    }

    public Set<Rule> selectRules(String ... onlyRunRules) {
        HashSet ruleNames = Sets.newHashSet((Object[])onlyRunRules);
        HashSet selectedRules = Sets.newHashSet();
        if (ruleNames.contains("all")) {
            selectedRules.addAll(Sets.newHashSet(this.availableRules));
        } else {
            HashSet rulesNotMatched = Sets.newHashSet();
            HashSet rulesMatched = Sets.newHashSet();
            for (String ruleName : ruleNames) {
                for (Rule rule : this.availableRules) {
                    if (rule.getIdentifier().equals(ruleName)) {
                        selectedRules.add(rule);
                        rulesMatched.add(ruleName);
                        rulesNotMatched.remove(ruleName);
                        continue;
                    }
                    if (rulesMatched.contains(ruleName)) continue;
                    rulesNotMatched.add(ruleName);
                }
            }
            if (!rulesNotMatched.isEmpty()) {
                throw new IllegalArgumentException("unsupported rule(s) " + Joiner.on((String)",").join((Iterable)rulesNotMatched));
            }
        }
        return selectedRules;
    }

    public Set<Rule> selectRules(PatternSet rulePatterns) {
        List<Pattern> excludePatterns = PatternSetUtil.convertGlobsToRegex(rulePatterns.getExcludes());
        List<Pattern> includePatterns = PatternSetUtil.convertGlobsToRegex(rulePatterns.getIncludes());
        Set<Rule> excludedRules = this.createRulesFromPattern(excludePatterns);
        Set<Rule> includedRules = this.createRulesFromPattern(includePatterns);
        includedRules.removeAll(excludedRules);
        return includedRules;
    }

    public Set<Rule> selectRules(PatternSet rulePatterns, String ... onlyRunRules) {
        PatternSet rulePatternsCopy = new PatternSet();
        if (rulePatterns == null) {
            rulePatternsCopy.setExcludes(new ArrayList());
            rulePatternsCopy.setIncludes((List)Lists.newArrayList((Object[])new String[]{"*"}));
        } else {
            if (rulePatterns.getIncludes().isEmpty()) {
                rulePatternsCopy.setIncludes((List)Lists.newArrayList((Object[])new String[]{"*"}));
            } else {
                rulePatternsCopy.setIncludes(rulePatterns.getIncludes());
            }
            if (rulePatterns.getExcludes().isEmpty()) {
                rulePatternsCopy.setExcludes(new ArrayList());
            } else {
                rulePatternsCopy.setExcludes(rulePatterns.getExcludes());
            }
        }
        Set<Rule> rulesByList = this.selectRules(onlyRunRules);
        return new RulesSelector(rulesByList).selectRules(rulePatternsCopy);
    }

    private Set<Rule> createRulesFromPattern(List<Pattern> patternList) {
        HashSet ruleSet = Sets.newHashSet();
        for (Rule rule : this.availableRules) {
            if (!this.matches(patternList, rule.getIdentifier())) continue;
            ruleSet.add(rule);
        }
        return ruleSet;
    }

    private boolean matches(List<Pattern> patterns, String identifier) {
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(identifier).matches()) continue;
            return true;
        }
        return false;
    }
}

