/*
 * Decompiled with CFR 0.152.
 */
package com.lewisd.maven.lint.plugin;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public final class PatternSetUtil {
    private PatternSetUtil() {
    }

    public static String convertGlobToRegex(String glob) {
        StringBuilder sb = new StringBuilder(94);
        block6: for (int i = 0; i < glob.length(); ++i) {
            char c = glob.charAt(i);
            switch (c) {
                case '*': {
                    sb.append(".*");
                    continue block6;
                }
                case '?': {
                    sb.append('.');
                    continue block6;
                }
                case '.': {
                    sb.append("\\.");
                    continue block6;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        sb.append('$');
        return sb.toString();
    }

    public static List<Pattern> convertGlobsToRegex(List<String> globs) {
        ArrayList patterns = Lists.newArrayListWithCapacity((int)globs.size());
        for (String glob : globs) {
            patterns.add(Pattern.compile(PatternSetUtil.convertGlobToRegex(glob)));
        }
        return patterns;
    }
}

