/*
 * Decompiled with CFR 0.152.
 */
package com.lewisd.maven.lint.plugin;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public abstract class AbstractContextMojo
extends AbstractMojo {
    @Component
    private MavenProject project;
    @Component
    private MavenSession session;
    @Component
    private MojoExecution mojoExecution;
    @Parameter(required=true, property="maven-lint.config.location", defaultValue="config/maven_lint.xml")
    private String configLocation;
    private final GenericApplicationContext applicationContext = new GenericApplicationContext();

    protected void initializeConfig() throws DependencyResolutionRequiredException, IOException {
        List testClasspathElements = this.project.getTestClasspathElements();
        URL[] testUrls = new URL[testClasspathElements.size()];
        for (int i = 0; i < testClasspathElements.size(); ++i) {
            String element = (String)testClasspathElements.get(i);
            testUrls[i] = new File(element).toURI().toURL();
        }
        URLClassLoader classLoader = new URLClassLoader(testUrls, Thread.currentThread().getContextClassLoader());
        ClassPathResource classPathResource = new ClassPathResource(this.configLocation, (ClassLoader)classLoader);
        XmlBeanDefinitionReader xmlBeanDefinitionReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)this.applicationContext);
        xmlBeanDefinitionReader.loadBeanDefinitions((Resource)classPathResource);
        this.applicationContext.getBeanFactory().registerSingleton("log", (Object)this.getLog());
        this.applicationContext.refresh();
    }

    protected GenericApplicationContext getContext() {
        return this.applicationContext;
    }

    protected void init() throws MojoExecutionException {
        PluginParameterExpressionEvaluator pluginParameterExpressionEvaluator = new PluginParameterExpressionEvaluator(this.session, this.mojoExecution);
        this.getContext().getBeanFactory().registerResolvableDependency(PluginParameterExpressionEvaluator.class, (Object)pluginParameterExpressionEvaluator);
        try {
            this.initializeConfig();
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Failed to initialize lint-maven-plugin", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to initialize lint-maven-plugin", (Exception)e);
        }
    }

    protected MavenProject getProject() {
        return this.project;
    }
}

