/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.phase01generatesources;

import com.jayway.maven.plugins.android.AbstractAndroidMojo;
import com.jayway.maven.plugins.android.CommandExecutor;
import com.jayway.maven.plugins.android.ExecutionException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipUnArchiver;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateSourcesMojo
extends AbstractAndroidMojo {
    protected boolean deleteConflictingFiles;
    protected File genDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.extractSourceDependencies();
            final String[] relativeAidlFileNames1 = this.findRelativeAidlFileNames(this.sourceDirectory);
            final String[] relativeAidlFileNames2 = this.findRelativeAidlFileNames(this.extractedDependenciesJavaSources);
            HashSet<String> relativeAidlFileNamesSet = new HashSet<String>(){
                {
                    this.addAll(Arrays.asList(relativeAidlFileNames1));
                    this.addAll(Arrays.asList(relativeAidlFileNames2));
                }
            };
            if (this.deleteConflictingFiles) {
                this.deleteConflictingRJavaFiles(this.sourceDirectory);
                this.deleteConflictingManifestJavaFiles(this.sourceDirectory);
                this.deleteConflictingThumbsDb(this.resourceDirectory);
                this.deleteConflictingAidlJavaFiles(this.sourceDirectory, (Collection<String>)relativeAidlFileNamesSet);
                this.deleteConflictingAidlJavaFiles(this.extractedDependenciesJavaSources, (Collection<String>)relativeAidlFileNamesSet);
            }
            this.generateR();
            this.generateAidlFiles(this.sourceDirectory, relativeAidlFileNames1);
            this.generateAidlFiles(this.extractedDependenciesJavaSources, relativeAidlFileNames2);
        }
        catch (MojoExecutionException e) {
            this.getLog().error((CharSequence)"Error when generating sources.", (Throwable)e);
            throw e;
        }
    }

    protected void extractSourceDependencies() throws MojoExecutionException {
        for (Artifact artifact : this.getRelevantDependencyArtifacts()) {
            String type = artifact.getType();
            if (!type.equals("apksources")) continue;
            this.getLog().debug((CharSequence)("Detected apksources dependency " + artifact + " with file " + artifact.getFile() + ". Will resolve and extract..."));
            File apksourcesFile = new File(this.getLocalRepository().getBasedir(), this.getLocalRepository().pathOf(artifact));
            if (apksourcesFile.isDirectory()) {
                apksourcesFile = this.resolveArtifactToFile(artifact);
            }
            this.getLog().debug((CharSequence)("Extracting " + apksourcesFile + "..."));
            this.extractApksources(apksourcesFile);
        }
        this.projectHelper.addResource(this.project, this.extractedDependenciesJavaResources.getAbsolutePath(), null, null);
        this.project.addCompileSourceRoot(this.extractedDependenciesJavaSources.getAbsolutePath());
    }

    private void extractApksources(File apksourcesFile) throws MojoExecutionException {
        if (apksourcesFile.isDirectory()) {
            this.getLog().warn((CharSequence)("The apksources artifact points to '" + apksourcesFile + "' which is a directory; skipping unpacking it."));
            return;
        }
        ZipUnArchiver unArchiver = new ZipUnArchiver(apksourcesFile){

            protected Logger getLogger() {
                return new ConsoleLogger(0, "dependencies-unarchiver");
            }
        };
        this.extractedDependenciesDirectory.mkdirs();
        unArchiver.setDestDirectory(this.extractedDependenciesDirectory);
        try {
            unArchiver.extract();
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("ArchiverException while extracting " + apksourcesFile.getAbsolutePath() + ". Message: " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
    }

    private void deleteConflictingManifestJavaFiles(File sourceDirectory) throws MojoExecutionException {
        int numberOfFilesDeleted = this.deleteFilesFromDirectory(sourceDirectory, "**/Manifest.java");
        if (numberOfFilesDeleted > 0) {
            this.getLog().info((CharSequence)("Deleted " + numberOfFilesDeleted + " conflicting Manifest.java file(s) in source directory. If you use Eclipse, please Refresh (F5) the project to regain it."));
        }
    }

    private void deleteConflictingRJavaFiles(File sourceDirectory) throws MojoExecutionException {
        int numberOfFilesDeleted = this.deleteFilesFromDirectory(sourceDirectory, "**/R.java");
        if (numberOfFilesDeleted > 0) {
            this.getLog().info((CharSequence)("Deleted " + numberOfFilesDeleted + " conflicting R.java file(s) in source directory. If you use Eclipse, please Refresh (F5) the project to regain it."));
        }
    }

    private void deleteConflictingThumbsDb(File resourceDirectory) throws MojoExecutionException {
        int numberOfFilesDeleted = this.deleteFilesFromDirectory(resourceDirectory, "**/Thumbs.db");
        if (numberOfFilesDeleted > 0) {
            this.getLog().info((CharSequence)("Deleted " + numberOfFilesDeleted + " Thumbs.db file(s) in resource directory."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteConflictingAidlJavaFiles(File sourceDirectory, Collection<String> relativeAidlFileNames) throws MojoExecutionException {
        for (String relativeAidlFileName : relativeAidlFileNames) {
            String relativeJavaFileName = relativeAidlFileName.substring(0, relativeAidlFileName.lastIndexOf(".")) + ".java";
            File conflictingJavaFileInSourceDirectory = new File(sourceDirectory, relativeJavaFileName);
            if (!conflictingJavaFileInSourceDirectory.exists()) continue;
            boolean shouldDelete = false;
            try {
                LineIterator lineIterator = FileUtils.lineIterator((File)conflictingJavaFileInSourceDirectory);
                try {
                    while (!shouldDelete && lineIterator.hasNext()) {
                        if (!lineIterator.nextLine().contains("interface")) continue;
                        shouldDelete = true;
                    }
                }
                finally {
                    lineIterator.close();
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not inspect aidl file \"" + conflictingJavaFileInSourceDirectory.getAbsolutePath() + "\".");
            }
            if (!shouldDelete) continue;
            boolean successfullyDeleted = conflictingJavaFileInSourceDirectory.delete();
            if (successfullyDeleted) {
                this.getLog().info((CharSequence)("Deleted conflicting file in source directory: \"" + conflictingJavaFileInSourceDirectory + "\". If you use Eclipse, please Refresh (F5) the project to regain them."));
                continue;
            }
            throw new MojoExecutionException("Failed to delete conflicting file in source directory: \"" + conflictingJavaFileInSourceDirectory + "\"");
        }
    }

    private void generateR() throws MojoExecutionException {
        this.genDirectory.mkdirs();
        File[] overlayDirectories = this.resourceOverlayDirectories == null || this.resourceOverlayDirectories.length == 0 ? new File[]{this.resourceOverlayDirectory} : this.resourceOverlayDirectories;
        if (!this.combinedRes.exists() && !this.combinedRes.mkdirs()) {
            throw new MojoExecutionException("Could not create directory for combined resources at " + this.combinedRes.getAbsolutePath());
        }
        if (this.extractedDependenciesRes.exists()) {
            try {
                this.getLog().info((CharSequence)"Copying dependency resource files to combined resource directory.");
                FileUtils.copyDirectory((File)this.extractedDependenciesRes, (File)this.combinedRes);
            }
            catch (IOException e) {
                throw new MojoExecutionException("", (Exception)e);
            }
        }
        if (this.resourceDirectory.exists()) {
            try {
                this.getLog().info((CharSequence)"Copying local resource files to combined resource directory.");
                FileUtils.copyDirectory((File)this.resourceDirectory, (File)this.combinedRes);
            }
            catch (IOException e) {
                throw new MojoExecutionException("", (Exception)e);
            }
        }
        CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
        executor.setLogger(this.getLog());
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("package");
        commands.add("-m");
        commands.add("-J");
        commands.add(this.genDirectory.getAbsolutePath());
        commands.add("-M");
        commands.add(this.androidManifestFile.getAbsolutePath());
        for (File resOverlayDir : overlayDirectories) {
            if (resOverlayDir == null || !resOverlayDir.exists()) continue;
            commands.add("-S");
            commands.add(resOverlayDir.getAbsolutePath());
        }
        if (this.combinedRes.exists()) {
            commands.add("-S");
            commands.add(this.combinedRes.getAbsolutePath());
        }
        if (this.assetsDirectory.exists()) {
            commands.add("-A");
            commands.add(this.assetsDirectory.getAbsolutePath());
        }
        if (this.extractedDependenciesAssets.exists()) {
            commands.add("-A");
            commands.add(this.extractedDependenciesAssets.getAbsolutePath());
        }
        commands.add("-I");
        commands.add(this.getAndroidSdk().getAndroidJar().getAbsolutePath());
        if (StringUtils.isNotBlank((String)this.configurations)) {
            commands.add("-c");
            commands.add(this.configurations);
        }
        this.getLog().info((CharSequence)(this.getAndroidSdk().getPathForTool("aapt") + " " + ((Object)commands).toString()));
        try {
            executor.executeCommand(this.getAndroidSdk().getPathForTool("aapt"), commands, this.project.getBasedir(), false);
        }
        catch (ExecutionException e) {
            throw new MojoExecutionException("", (Exception)e);
        }
        this.project.addCompileSourceRoot(this.genDirectory.getAbsolutePath());
    }

    private void generateAidlFiles(File sourceDirectory, String[] relativeAidlFileNames) throws MojoExecutionException {
        for (String relativeAidlFileName : relativeAidlFileNames) {
            ArrayList<String> commands = new ArrayList<String>();
            commands.add("-p" + this.getAndroidSdk().getPathForFrameworkAidl());
            File generatedSourcesAidlDirectory = new File(this.project.getBuild().getDirectory() + File.separator + "generated-sources" + File.separator + "aidl");
            generatedSourcesAidlDirectory.mkdirs();
            this.project.addCompileSourceRoot(generatedSourcesAidlDirectory.getPath());
            File targetDirectory = new File(generatedSourcesAidlDirectory, new File(relativeAidlFileName).getParent());
            targetDirectory.mkdirs();
            String shortAidlFileName = new File(relativeAidlFileName).getName();
            String shortJavaFileName = shortAidlFileName.substring(0, shortAidlFileName.lastIndexOf(".")) + ".java";
            File aidlFileInSourceDirectory = new File(sourceDirectory, relativeAidlFileName);
            commands.add("-I" + sourceDirectory);
            commands.add(aidlFileInSourceDirectory.getAbsolutePath());
            commands.add(new File(targetDirectory, shortJavaFileName).getAbsolutePath());
            try {
                CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
                executor.setLogger(this.getLog());
                executor.executeCommand(this.getAndroidSdk().getPathForTool("aidl"), commands, this.project.getBasedir(), false);
            }
            catch (ExecutionException e) {
                throw new MojoExecutionException("", (Exception)e);
            }
        }
    }

    private String[] findRelativeAidlFileNames(File sourceDirectory) {
        String[] relativeAidlFileNames = this.findFilesInDirectory(sourceDirectory, "**/*.aidl");
        this.getLog().info((CharSequence)("ANDROID-904-002: Found aidl files: Count = " + relativeAidlFileNames.length));
        return relativeAidlFileNames;
    }
}

