/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android;

import com.jayway.maven.plugins.android.InvalidSdkException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndroidSdk {
    private static final String SOURCE_PROPERTIES_FILENAME = "source.properties";
    private static final String PLATFORM_VERSION_PROPERTY = "Platform.Version";
    private static final String API_LEVEL_PROPERTY = "AndroidVersion.ApiLevel";
    private static final String PLATFORMS_FOLDER_NAME = "platforms";
    private static final String PARAMETER_MESSAGE = "Please provide a proper Android SDK directory path as configuration parameter <sdk><path>...</path></sdk> in the plugin <configuration/>. As an alternative, you may add the parameter to commandline: -Dandroid.sdk.path=... or set environment variable ANDROID_HOME.";
    private final File sdkPath;
    private final Platform platform;
    private Set<Platform> availablePlatforms;
    private static final Set<String> commonToolsIn11And15 = new HashSet<String>(){
        {
            this.add("adb");
            this.add("android");
            this.add("apkbuilder");
            this.add("ddms");
            this.add("dmtracedump");
            this.add("draw9patch");
            this.add("emulator");
            this.add("hierarchyviewer");
            this.add("hprof-conv");
            this.add("mksdcard");
            this.add("sqlite3");
            this.add("traceview");
            this.add("zipalign");
        }
    };

    public AndroidSdk(File sdkPath, String platformOrApiLevel) {
        this.sdkPath = sdkPath;
        this.findAvailablePlatforms();
        if (platformOrApiLevel == null) {
            this.platform = null;
        } else {
            this.platform = this.findPlatformByNameOrApiLevel(platformOrApiLevel);
            if (this.platform == null) {
                throw new InvalidSdkException("Invalid SDK: Platform/API level " + platformOrApiLevel + " not available.");
            }
        }
    }

    private Platform findPlatformByNameOrApiLevel(String platformOrApiLevel) {
        for (Platform p : this.availablePlatforms) {
            if (!p.name.equals(platformOrApiLevel) && !p.apiLevel.equals(platformOrApiLevel)) continue;
            return p;
        }
        return null;
    }

    public Layout getLayout() {
        this.assertPathIsDirectory(this.sdkPath);
        File platforms = new File(this.sdkPath, PLATFORMS_FOLDER_NAME);
        if (platforms.exists() && platforms.isDirectory()) {
            return Layout.LAYOUT_1_5;
        }
        File androidJar = new File(this.sdkPath, "android.jar");
        if (androidJar.exists() && androidJar.isFile()) {
            return Layout.LAYOUT_1_1;
        }
        throw new InvalidSdkException("Android SDK could not be identified from path \"" + this.sdkPath + "\". " + PARAMETER_MESSAGE);
    }

    private void assertPathIsDirectory(File path) {
        if (path == null) {
            throw new InvalidSdkException(PARAMETER_MESSAGE);
        }
        if (!path.isDirectory()) {
            throw new InvalidSdkException("Path \"" + path + "\" is not a directory. " + PARAMETER_MESSAGE);
        }
    }

    public String getPathForTool(String tool) {
        if (this.getLayout() == Layout.LAYOUT_1_1) {
            return this.sdkPath + "/tools/" + tool;
        }
        if (this.getLayout() == Layout.LAYOUT_1_5) {
            if (commonToolsIn11And15.contains(tool)) {
                return this.sdkPath + "/tools/" + tool;
            }
            return this.getPlatform() + "/tools/" + tool;
        }
        throw new InvalidSdkException("Unsupported layout \"" + (Object)((Object)this.getLayout()) + "\"! " + PARAMETER_MESSAGE);
    }

    public String getEmulatorPath() {
        return this.getPathForTool("emulator");
    }

    public String getAdbPath() {
        return this.getPathForTool("adb");
    }

    public String getZipalignPath() {
        return this.getPathForTool("zipalign");
    }

    public String getPathForFrameworkAidl() {
        if (this.getLayout() == Layout.LAYOUT_1_1) {
            return this.sdkPath + "/tools/lib/framework.aidl";
        }
        if (this.getLayout() == Layout.LAYOUT_1_5) {
            return this.getPlatform() + "/framework.aidl";
        }
        throw new InvalidSdkException("Unsupported layout \"" + (Object)((Object)this.getLayout()) + "\"! " + PARAMETER_MESSAGE);
    }

    public File getAndroidJar() throws MojoExecutionException {
        if (this.getLayout() == Layout.LAYOUT_1_1) {
            return new File(this.sdkPath + "/android.jar");
        }
        if (this.getLayout() == Layout.LAYOUT_1_5) {
            return new File(this.getPlatform() + "/android.jar");
        }
        throw new MojoExecutionException("Invalid Layout \"" + (Object)((Object)this.getLayout()) + "\"! " + PARAMETER_MESSAGE);
    }

    public File getPlatform() {
        this.assertPathIsDirectory(this.sdkPath);
        if (this.getLayout() == Layout.LAYOUT_1_1) {
            return this.sdkPath;
        }
        File platformsDirectory = new File(this.sdkPath, PLATFORMS_FOLDER_NAME);
        this.assertPathIsDirectory(platformsDirectory);
        if (this.platform == null) {
            Object[] platformDirectories = platformsDirectory.listFiles();
            Arrays.sort(platformDirectories);
            return platformDirectories[platformDirectories.length - 1];
        }
        File platformDirectory = new File(this.platform.path);
        this.assertPathIsDirectory(platformDirectory);
        return platformDirectory;
    }

    private void findAvailablePlatforms() throws InvalidSdkException {
        this.availablePlatforms = new HashSet<Platform>();
        ArrayList<File> platformDirectories = this.getPlatformDirectories();
        for (File pDir : platformDirectories) {
            File propFile = new File(pDir, SOURCE_PROPERTIES_FILENAME);
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(propFile));
            }
            catch (IOException e) {
                throw new InvalidSdkException("Error reading " + propFile.getAbsoluteFile());
            }
            if (!properties.containsKey(PLATFORM_VERSION_PROPERTY) || !properties.containsKey(API_LEVEL_PROPERTY)) continue;
            String platform = properties.getProperty(PLATFORM_VERSION_PROPERTY);
            String apiLevel = properties.getProperty(API_LEVEL_PROPERTY);
            this.availablePlatforms.add(new Platform(platform, apiLevel, pDir.getAbsolutePath()));
        }
    }

    private ArrayList<File> getPlatformDirectories() {
        File[] platformDirectories;
        ArrayList<File> sourcePropertyFiles = new ArrayList<File>();
        File platformsDirectory = new File(this.sdkPath, PLATFORMS_FOLDER_NAME);
        this.assertPathIsDirectory(platformsDirectory);
        for (File file : platformDirectories = platformsDirectory.listFiles()) {
            if (!file.isDirectory() || !file.getName().startsWith("android-")) continue;
            sourcePropertyFiles.add(file);
        }
        return sourcePropertyFiles;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Layout {
        LAYOUT_1_1,
        LAYOUT_1_5;

    }

    private static final class Platform {
        final String name;
        final String apiLevel;
        final String path;

        public Platform(String name, String apiLevel, String path) {
            this.name = name;
            this.apiLevel = apiLevel;
            this.path = path;
        }
    }
}

