/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.phase01generatesources;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class ManifestMerger {
    private static Log log;
    private static Object merger;
    private static Method processMethod;

    public void initialize(Log log, File sdkLibs, File mergerLib) throws MojoExecutionException {
        if (processMethod != null && merger != null) {
            return;
        }
        ManifestMerger.log = log;
        URLClassLoader mlLoader = null;
        Class<?> manifestMergerClass = null;
        Class<?> mergerLogClass = null;
        try {
            mlLoader = new URLClassLoader(new URL[]{mergerLib.toURI().toURL()}, ManifestMerger.class.getClassLoader());
            manifestMergerClass = mlLoader.loadClass("com.android.manifmerger.ManifestMerger");
            log.debug((CharSequence)("ManifestMerger loaded " + manifestMergerClass));
            mergerLogClass = mlLoader.loadClass("com.android.manifmerger.MergerLog");
            log.debug((CharSequence)("ManifestMerger loaded " + mergerLogClass));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Cannot create a correct URL from file " + mergerLib.getAbsolutePath());
        }
        catch (ClassNotFoundException e) {
            log.error((CharSequence)"Cannot find required class", (Throwable)e);
            throw new MojoExecutionException("Cannot find the required class", (Exception)e);
        }
        Class<?> nullSdkLogClass = null;
        try {
            URLClassLoader child = new URLClassLoader(new URL[]{sdkLibs.toURI().toURL()}, (ClassLoader)mlLoader);
            nullSdkLogClass = child.loadClass("com.android.sdklib.NullSdkLog");
            log.debug((CharSequence)("NullSdkLog loaded " + nullSdkLogClass));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Cannot create a correct URL from file " + sdkLibs.getAbsolutePath());
        }
        catch (ClassNotFoundException e) {
            log.error((CharSequence)"Cannot find required class", (Throwable)e);
            throw new MojoExecutionException("Cannot find the required class", (Exception)e);
        }
        try {
            processMethod = manifestMergerClass.getMethod("process", File.class, File.class, File[].class);
        }
        catch (Exception e) {
            log.error((CharSequence)"Cannot find required method", (Throwable)e);
            throw new MojoExecutionException("Cannot find the required method", e);
        }
        try {
            Method getLoggerMethod = nullSdkLogClass.getMethod("getLogger", new Class[0]);
            Object sdkLog = getLoggerMethod.invoke(null, new Object[0]);
            Method wrapSdkLogMethod = mergerLogClass.getMethod("wrapSdkLog", nullSdkLogClass.getInterfaces()[0]);
            Object iMergerLog = wrapSdkLogMethod.invoke(null, sdkLog.getClass().getInterfaces()[0].cast(sdkLog));
            Constructor<?> manifestMergerConstructor = manifestMergerClass.getDeclaredConstructors()[0];
            merger = manifestMergerConstructor.newInstance(iMergerLog);
        }
        catch (InvocationTargetException e) {
            log.error((CharSequence)"Cannot create the ManifestMerger object", e.getCause());
            throw new MojoExecutionException("Cannot create the ManifestMerger object", e.getCause());
        }
        catch (Exception e) {
            log.error((CharSequence)"Cannot create the ManifestMerger object", (Throwable)e);
            throw new MojoExecutionException("Cannot create the ManifestMerger object", e);
        }
    }

    public ManifestMerger(Log log, File sdkLibs, File mergerLib) throws MojoExecutionException {
        this.initialize(log, sdkLibs, mergerLib);
    }

    public boolean process(File paramFile1, File paramFile2, File[] paramArayOfFile) throws MojoExecutionException {
        try {
            return (Boolean)processMethod.invoke(merger, paramFile1, paramFile2, paramArayOfFile);
        }
        catch (Exception e) {
            log.error((CharSequence)"Cannot merge the manifests", (Throwable)e);
            throw new MojoExecutionException("Cannot merge the manifests", e);
        }
    }
}

