/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.phase09package;

import com.jayway.maven.plugins.android.AbstractAndroidMojo;
import com.jayway.maven.plugins.android.CommandExecutor;
import com.jayway.maven.plugins.android.ExecutionException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.util.DefaultFileSet;

public class ApklibMojo
extends AbstractAndroidMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.generateIntermediateApk();
        CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
        executor.setLogger(this.getLog());
        File outputFile = this.createApkLibraryFile();
        this.project.getArtifact().setFile(outputFile);
    }

    protected File createApkLibraryFile() throws MojoExecutionException {
        File apklibrary = new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + "." + "apklib");
        FileUtils.deleteQuietly((File)apklibrary);
        try {
            JarArchiver jarArchiver = new JarArchiver();
            jarArchiver.setDestFile(apklibrary);
            jarArchiver.addFile(this.androidManifestFile, "AndroidManifest.xml");
            this.addDirectory(jarArchiver, this.assetsDirectory, "assets");
            this.addDirectory(jarArchiver, this.resourceDirectory, "res");
            this.addDirectory(jarArchiver, this.sourceDirectory, "src");
            this.addJavaResources(jarArchiver, this.project.getBuild().getResources(), "src");
            this.addNativeLibraries(jarArchiver);
            jarArchiver.createArchive();
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("ArchiverException while creating .apklib file.", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("IOException while creating .apklib file.", (Exception)e);
        }
        return apklibrary;
    }

    private void addNativeLibraries(JarArchiver jarArchiver) throws MojoExecutionException {
        try {
            this.addDirectory(jarArchiver, this.nativeLibrariesDirectory, "libs");
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("IOException while creating .apklib file.", (Exception)((Object)e));
        }
    }

    protected void addJavaResources(JarArchiver jarArchiver, List<Resource> javaResources, String prefix) throws IOException {
        for (Resource javaResource : javaResources) {
            this.addJavaResource(jarArchiver, javaResource, prefix);
        }
    }

    protected void addJavaResource(JarArchiver jarArchiver, Resource javaResource, String prefix) throws IOException {
        String apkLibUnpackBasePath;
        String resourcePath;
        File javaResourceDirectory;
        if (javaResource != null && (javaResourceDirectory = new File(javaResource.getDirectory())).exists() && !(resourcePath = javaResourceDirectory.getCanonicalPath()).startsWith(apkLibUnpackBasePath = this.unpackedApkLibsDirectory.getCanonicalPath())) {
            DefaultFileSet javaResourceFileSet = new DefaultFileSet();
            javaResourceFileSet.setDirectory(javaResourceDirectory);
            javaResourceFileSet.setPrefix(this.endWithSlash(prefix));
            jarArchiver.addFileSet((FileSet)javaResourceFileSet);
        }
    }

    protected String endWithSlash(String prefix) {
        if (!(prefix = StringUtils.defaultIfEmpty((String)prefix, (String)"/")).endsWith("/")) {
            prefix = prefix + "/";
        }
        return prefix;
    }

    protected void addDirectory(JarArchiver jarArchiver, File directory, String prefix) {
        if (directory != null && directory.exists()) {
            DefaultFileSet fileSet = new DefaultFileSet();
            fileSet.setPrefix(this.endWithSlash(prefix));
            fileSet.setDirectory(directory);
            jarArchiver.addFileSet((FileSet)fileSet);
        }
    }

    private void generateIntermediateApk() throws MojoExecutionException {
        CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
        executor.setLogger(this.getLog());
        File[] overlayDirectories = this.resourceOverlayDirectories == null || this.resourceOverlayDirectories.length == 0 ? new File[]{this.resourceOverlayDirectory} : this.resourceOverlayDirectories;
        File androidJar = this.getAndroidSdk().getAndroidJar();
        File outputFile = new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + ".ap_");
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("package");
        commands.add("-f");
        commands.add("-M");
        commands.add(this.androidManifestFile.getAbsolutePath());
        for (File resOverlayDir : overlayDirectories) {
            if (resOverlayDir == null || !resOverlayDir.exists()) continue;
            commands.add("-S");
            commands.add(resOverlayDir.getAbsolutePath());
        }
        if (this.combinedRes.exists()) {
            commands.add("-S");
            commands.add(this.combinedRes.getAbsolutePath());
        } else if (this.resourceDirectory.exists()) {
            commands.add("-S");
            commands.add(this.resourceDirectory.getAbsolutePath());
        }
        for (Artifact apkLibraryArtifact : this.getAllRelevantDependencyArtifacts()) {
            if (!apkLibraryArtifact.getType().equals("apklib")) continue;
            commands.add("-S");
            commands.add(this.getLibraryUnpackDirectory(apkLibraryArtifact) + "/res");
        }
        commands.add("--auto-add-overlay");
        if (this.assetsDirectory.exists()) {
            commands.add("-A");
            commands.add(this.assetsDirectory.getAbsolutePath());
        }
        if (this.extractedDependenciesAssets.exists()) {
            commands.add("-A");
            commands.add(this.extractedDependenciesAssets.getAbsolutePath());
        }
        commands.add("-I");
        commands.add(androidJar.getAbsolutePath());
        commands.add("-F");
        commands.add(outputFile.getAbsolutePath());
        if (StringUtils.isNotBlank((String)this.configurations)) {
            commands.add("-c");
            commands.add(this.configurations);
        }
        this.getLog().info((CharSequence)(this.getAndroidSdk().getPathForTool("aapt") + " " + ((Object)commands).toString()));
        try {
            executor.executeCommand(this.getAndroidSdk().getPathForTool("aapt"), commands, this.project.getBasedir(), false);
        }
        catch (ExecutionException e) {
            throw new MojoExecutionException("", (Exception)e);
        }
    }
}

